
        page    64,131
	Title	MVSTATE --  Audio Spectrum Sound Support Code

;   /*\
;   |*|----====< MVSTATE >====----
;   |*|
;   |*|  This module maintains the state table and pointer
;   |*|
;   |*|  Media Vision, Inc. Copyright (c) 1991,1992. All Rights Reserved.
;   |*|
;   \*/

	.xlist
	include model.inc
        include masm.inc
	include state.inc
	include common.inc
	.list
	.data
;
; This pointer points to a state table of hardware variables
;
        public  mvhwShadowPointer
mvhwShadowPointer	dd	0	; points to the start of the data table

;
; These variables mirror the hardware state
;
HardwareShadowTable	db	(size MVState) dup (0)

	.code
;
;   /*\
;---|*|---------------====< MVInitStatePtr() >====---------------
;---|*|
;---|*| Initializes the state table pointer.
;---|*|
;---|*| Entry Conditions:
;---|*|     None
;---|*|
;---|*| Exit Conditions:
;---|*|     DX:AX point to the state table
;   \*/

	public	MVInitStatePtr
MVInitStatePtr	proc
;
; this code can only be processed once per loading
;
	cmp	wptr [mvhwShadowPointer+2],0	; have we been here?
	jnz	imvsp_done			; yes, don't do this again
;
; setup a pointer to our local hardware state table
;
	lea	bx,HardwareShadowTable
	mov	wptr [mvhwShadowPointer+0],bx
	mov	wptr [mvhwShadowPointer+2],ds

	mov	[bx._audiomixr],31h	; lowest filter setting
	mov	[bx._crosschannel],09h	; cross channel l-2-l, r-2-r
;
; find the int 2F interface and if found, use it's state table pointer
;
	mov	ax,0BC00h		; MVSOUND.SYS ID check
	mov	bx,'??'
	sub	cx,cx
	sub	dx,dx

	int	2fh			; will return something if loaded

	xor	bx,cx
	xor	bx,dx
	cmp	bx,'MV'                 ; is the int 2F interface here?
	jnz	imvsp_done		; no, exit home

	mov	ax,0BC02H		; get the pointer
        int     2fh
	cmp	ax,'MV'                 ; busy or intercepted
	jnz	imvsp_done

	mov	wptr [mvhwShadowPointer+0],bx
	mov	wptr [mvhwShadowPointer+2],dx
;
imvsp_done:
	mov	ax,wptr [mvhwShadowPointer+0]
	mov	dx,wptr [mvhwShadowPointer+2]

        ret

MVInitStatePtr	endp

	end

