/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.Expression;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class VariableExpression
extends Expression {
    private List<String> path;
    private Object namespace;
    private PathMonitor pathMonitor = null;

    public VariableExpression(List<String> list, Object object) {
        if (list == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        this.path = Collections.unmodifiableList(list);
        this.namespace = object;
    }

    public List<String> getPath() {
        return this.path;
    }

    public Object getNamespace() {
        return this.namespace;
    }

    @Override
    protected Object evaluate() {
        return VariableExpression.get(this.namespace, this.path);
    }

    @Override
    public boolean isDefined() {
        return VariableExpression.isDefined(this.namespace, this.path);
    }

    @Override
    protected void registerChangeListeners() {
        if (this.pathMonitor == null) {
            this.pathMonitor = new PathMonitor(this.path);
            this.pathMonitor.registerChangeListeners();
        }
    }

    @Override
    protected void unregisterChangeListeners() {
        if (this.pathMonitor != null) {
            this.pathMonitor.unregisterChangeListeners();
            this.pathMonitor = null;
        }
    }

    public String toString() {
        return this.path.toString();
    }

    private class PathMonitor {
        public final List<String> path;
        public final LinkedList<Object> collections = new LinkedList();
        private ListChangeListener<Object> listChangeListener = new ListChangeListener<Object>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Object> change) {
                while (change.next()) {
                    int n;
                    ObservableList<? extends Object> observableList = change.getList();
                    Iterator<Object> iterator = PathMonitor.this.collections.iterator();
                    Iterator<String> iterator2 = PathMonitor.this.path.iterator();
                    String string = null;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        string = iterator2.next();
                        if (e != observableList) continue;
                        break;
                    }
                    if ((n = Integer.parseInt(string)) < change.getFrom() || n >= change.getTo()) continue;
                    VariableExpression.this.invalidate();
                    if (iterator.hasNext()) {
                        PathMonitor.this.unregisterChangeListeners(iterator);
                    }
                    if (!iterator2.hasNext()) continue;
                    PathMonitor.this.registerChangeListeners(Expression.get(observableList, string), iterator2);
                }
            }
        };
        private MapChangeListener<String, Object> mapChangeListener = new MapChangeListener<String, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
                ObservableMap<? extends String, ? extends Object> observableMap = change.getMap();
                Iterator<Object> iterator = PathMonitor.this.collections.iterator();
                Iterator<String> iterator2 = PathMonitor.this.path.iterator();
                String string = null;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    string = iterator2.next();
                    if (e != observableMap) continue;
                    break;
                }
                if (string.equals(change.getKey())) {
                    VariableExpression.this.invalidate();
                    if (iterator.hasNext()) {
                        PathMonitor.this.unregisterChangeListeners(iterator);
                    }
                    if (iterator2.hasNext()) {
                        PathMonitor.this.registerChangeListeners(Expression.get(observableMap, string), iterator2);
                    }
                }
            }
        };

        public PathMonitor(List<String> list) {
            this.path = list;
        }

        public void registerChangeListeners() {
            this.registerChangeListeners(VariableExpression.this.namespace, this.path.iterator());
        }

        public void registerChangeListeners(Object object, Iterator<String> iterator) {
            Observable observable;
            String string = iterator.next();
            if (object instanceof ObservableList) {
                ObservableList observableList = (ObservableList)object;
                observableList.addListener(this.listChangeListener);
                observable = observableList;
            } else {
                ObservableMap observableMap = object instanceof Map ? (ObservableMap)object : new BeanAdapter(object);
                observableMap.addListener(this.mapChangeListener);
                observable = observableMap;
            }
            this.collections.add(observable);
            if (iterator.hasNext() && (object = Expression.get(object, string)) != null) {
                this.registerChangeListeners(object, iterator);
            }
        }

        public void unregisterChangeListeners() {
            this.unregisterChangeListeners(this.collections.iterator());
        }

        public void unregisterChangeListeners(Iterator<Object> iterator) {
            Object object = iterator.next();
            if (object instanceof List) {
                ObservableList observableList = (ObservableList)object;
                observableList.removeListener(this.listChangeListener);
            } else {
                ObservableMap observableMap = (ObservableMap)object;
                observableMap.removeListener(this.mapChangeListener);
            }
            if (iterator.hasNext()) {
                this.unregisterChangeListeners(iterator);
            }
            this.collections.removeLast();
        }
    }
}

