/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import nn.pp.drvredir.Drive;
import nn.pp.drvredir.DriveAccess;
import nn.pp.drvredir.LibraryDownloader;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.T;

public class DrvRedirNative
implements DriveAccess {
    private static boolean already_loaded = false;
    static final int CD_EXT_MEDIUM_NO_CHANGE = 0;
    static final int CD_EXT_MEDIUM_REMOVED = 1;
    static final int CD_EXT_MEDIUM_CHANGED = 2;
    private URL codeBase;
    long cdExt = 0L;

    native boolean isSupportedByOSVersion();

    private native String cdExtGetAvailableDrives();

    private native long cdExtractionInit();

    private native void cdExtractionCleanup(long var1);

    private native boolean cdExtMediumChangeSupported(long var1);

    private native String getErrorString(int var1);

    private native int cdExtractionWriteISOImage(String var1, String var2, int var3);

    private native int cdExtGetDriveGeometry(long var1);

    private native int cdExtGetMSPDriveType(long var1);

    private native String cdExtGetDriveTypeString(String var1);

    private native int cdExtGetDriveType(String var1);

    private native int cdExtOpenDrive(long var1, String var3);

    private native int cdExtCloseDrive(long var1);

    private native int cdExtLockDriveRemoval(long var1, boolean var3);

    private native int cdExtLockDriveAccess(long var1, boolean var3, boolean var4, boolean var5);

    private native int cdExtGetSectorSize(long var1);

    private native int cdExtGetSectorNo(long var1);

    private native int cdExtReadCDSectors(long var1, long var3, long var5, byte[] var7);

    private native int cdExtWriteCDSectors(long var1, long var3, long var5, byte[] var7);

    private native int cdExtGetMediumChangeState(long var1);

    private native int cdExtMediumRemovedForChange(long var1);

    private native int cdExtMediumInsertedAfterChange(long var1);

    Drive[] getAvailableDrives() {
        Drive[] ret = null;
        String drives = this.cdExtGetAvailableDrives();
        if (drives != null && drives.length() > 0) {
            ret = new Drive[drives.length()];
            for (int i = 0; i < drives.length(); ++i) {
                ret[i] = new Drive("" + drives.charAt(i) + ":", this.getDriveTypeString("" + drives.charAt(i)));
            }
        }
        return ret;
    }

    void initDriveRedirection() throws Exception {
        this.cdExt = this.cdExtractionInit();
        if (this.cdExt == 0L) {
            throw new IOException(T._("Could not initialize Drive Redirection library."));
        }
    }

    void cleanupDriveRedirection() {
        if (this.cdExt != 0L) {
            this.cdExtractionCleanup(this.cdExt);
        }
        this.cdExt = 0L;
    }

    @Override
    public boolean mediumChangeSupported() {
        if (this.cdExt != 0L) {
            return this.cdExtMediumChangeSupported(this.cdExt);
        }
        return false;
    }

    void writeISOImage(String driveLetter, String filename, int sectors) throws IOException {
        int ret = this.cdExtractionWriteISOImage(driveLetter, filename, sectors);
        if (ret != 0) {
            throw new IOException(T._("Could not write ISO image:") + " " + this.getErrorString(ret));
        }
    }

    synchronized void getDriveGeometry() throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtGetDriveGeometry(this.cdExt)) != 0) {
            throw new IOException(T._("Could not query drive geometry:") + " " + this.getErrorString(ret));
        }
    }

    @Override
    public synchronized int getMSPDriveType() throws IOException {
        if (this.cdExt != 0L) {
            int ret = this.cdExtGetMSPDriveType(this.cdExt);
            if (ret < 0) {
                throw new IOException(T._("Could not query drive type:") + " " + this.getErrorString(ret));
            }
            return ret;
        }
        return 0;
    }

    synchronized String getDriveTypeString(String driveLetter) {
        return this.cdExtGetDriveTypeString(driveLetter);
    }

    synchronized void openDrive(String driveLetter) throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtOpenDrive(this.cdExt, driveLetter)) != 0) {
            throw new IOException(T._("Could not open drive:") + " " + this.getErrorString(ret));
        }
    }

    synchronized void closeDrive() throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtCloseDrive(this.cdExt)) != 0) {
            throw new IOException(T._("Could not close drive:") + " " + this.getErrorString(ret));
        }
    }

    synchronized void lockDriveRemoval(boolean unlock) throws IOException {
        if (this.cdExt != 0L) {
            int n = this.cdExtLockDriveRemoval(this.cdExt, unlock);
        }
    }

    synchronized void lockDriveAccess(boolean askOnError, boolean unlock) throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtLockDriveAccess(this.cdExt, false, askOnError, unlock)) != 0) {
            throw new IOException(T._("Could not lock drive access:") + " " + this.getErrorString(ret));
        }
    }

    @Override
    public synchronized int getSectorSize() {
        if (this.cdExt != 0L) {
            return this.cdExtGetSectorSize(this.cdExt);
        }
        return 1;
    }

    @Override
    public synchronized int getSectorNo() {
        if (this.cdExt != 0L) {
            return this.cdExtGetSectorNo(this.cdExt);
        }
        return 1;
    }

    @Override
    public synchronized void readCDSectors(long startSector, long noSectors, byte[] dataBuf) throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtReadCDSectors(this.cdExt, startSector, noSectors, dataBuf)) != 0) {
            throw new IOException(T._("Could not read from drive:") + " " + this.getErrorString(ret));
        }
    }

    @Override
    public synchronized void writeCDSectors(long startSector, long noSectors, byte[] dataBuf) throws IOException {
        int ret;
        if (this.cdExt != 0L && (ret = this.cdExtWriteCDSectors(this.cdExt, startSector, noSectors, dataBuf)) != 0) {
            throw new IOException(T._("Could not write to drive:") + " " + this.getErrorString(ret));
        }
    }

    public int getMediumChangeState() {
        return this.cdExtGetMediumChangeState(this.cdExt);
    }

    public synchronized void mediumRemovedForChange() {
        this.cdExtMediumRemovedForChange(this.cdExt);
    }

    public synchronized void mediumInsertedAfterChange() {
        this.cdExtMediumInsertedAfterChange(this.cdExt);
    }

    private void loadNativeCode() throws Exception {
        LibraryDownloader downloader = new LibraryDownloader();
        File libraryFile = this.codeBase != null ? downloader.downloadFromWeb(this.codeBase.toString()) : downloader.downloadFromLocalFile();
        try {
            System.load(libraryFile.getCanonicalPath().trim());
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
    }

    public DrvRedirNative(URL codeBase) throws Exception {
        this.codeBase = codeBase;
        try {
            if (!already_loaded) {
                this.loadNativeCode();
                already_loaded = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected void finalize() {
        this.cleanupDriveRedirection();
    }

    public boolean showLockConfirm() {
        ConfirmDialog dlg = new ConfirmDialog(T._("Access to the selected drive could not be locked.\nIf you continue, the remote computer may get confused when\nthe local computer writes data to the disk. The drive cache\nin the remote computer does not expect this.\n\nIf you have Write Support enabled, this will certainly lead\nto file system errors and destroy the data on the disk.\n\nDo you want to continue?"), T._("Locking drive failed."), 2, true);
        dlg.show();
        return dlg.yes;
    }
}

