/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.util.regex.Pattern;

public class IPMIOEMSMTPSenderCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private Pattern EMAIL_PATTERN = Pattern.compile("^\\w+\\.*\\w+@(\\w+\\.){1,5}[a-zA-Z]{2,3}$");

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length == 1) {
                if (!this.isValidEmail(this.parameters[0]) && this.parameters[0].length() != 0) {
                    MOut.G(this).println("Email format error!");
                    return false;
                }
            } else {
                MOut.G(this).println("Parameter error!");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This command supports X10 platform only ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            byte[] senderAddressData = ipmiOEMWebSettingCommand.getSMTP((byte)5);
            MOut.G(this).println(new String(senderAddressData));
        } else {
            byte[] sender = new byte[this.parameters[0].length() + 1];
            System.arraycopy(this.parameters[0].getBytes(), 0, sender, 0, this.parameters[0].length());
            ipmiOEMWebSettingCommand.setSMTP((byte)5, sender);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }

    private boolean isValidEmail(String email) {
        boolean result = false;
        if (this.EMAIL_PATTERN.matcher(email).matches()) {
            result = true;
        }
        return result;
    }
}

