/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMFlashCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        if (this.parameters == null) {
            MOut.G(this).println("firmware filename needed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = ipmiRaritanOEMCommand.flashFirmwareWithMessage(this.parameters[0]);
        if (!result) {
            MOut.G(this).println(" Failed (Please retry after 1 minute)");
        }
        this.statusCode = result ? 0 : 149;
    }

    public IPMIInterface reCreateNewIPMIInterface() {
        this.delay();
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiRaritanOEMCommand);
        if (sessionController == null) {
            return null;
        }
        return ipmiRaritanOEMCommand.getIPMIInterface();
    }

    public void delay() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

