/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.communication;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLWrapper {
    private SSLEngine engine;
    private SSLSession session;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private SSLEngineResult.HandshakeStatus hsStatus;
    public SocketChannel m_SocketChannel;
    public boolean m_IsSSLInited;

    public SSLWrapper(SocketChannel socket_channel) {
        this.m_SocketChannel = socket_channel;
        this.m_IsSSLInited = false;
        this.session = null;
    }

    public int setupBuffers() {
        int max_frame_size = 4500000;
        if (this.session != null) {
            this.appIn = ByteBuffer.allocateDirect(max_frame_size);
            this.appOut = ByteBuffer.allocateDirect(5000);
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netIn.order(ByteOrder.LITTLE_ENDIAN);
            this.netOut.order(ByteOrder.LITTLE_ENDIAN);
            Debug.out.println("Allocating SSL network buffers and application buffers");
            Debug.out.println("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            Debug.out.println("Allocated appOut buffer of " + this.appOut.capacity() + " bytes");
            Debug.out.println("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
            Debug.out.println("Allocated appIn buffer of " + this.appIn.capacity() + " bytes");
            return 0;
        }
        return -1;
    }

    public String GetDefaultTrustCertKeyStore_User() {
        String user_keystore = System.getProperty("deployment.user.security.trusted.certs");
        if (user_keystore == null) {
            String osname = System.getProperty("os.name");
            String TRUSTED_CERT_LOCATION_GUESS = "";
            if (osname.indexOf("Windows") > -1) {
                TRUSTED_CERT_LOCATION_GUESS = "\\Application Data\\Sun\\Java\\Deployment\\security\\trusted.certs";
            } else if (osname.indexOf("Linux") > -1) {
                TRUSTED_CERT_LOCATION_GUESS = ".java/deployment/security/trusted.certs";
            }
            String userHome = System.getProperty("user.home");
            user_keystore = userHome + TRUSTED_CERT_LOCATION_GUESS;
        }
        return user_keystore;
    }

    public String initSSL() throws IOException {
        SSLContext context = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            context = sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            return new String(LocaleStrings.GetString("3_1_SSLWRAPPER") + e.getMessage());
        }
        catch (KeyManagementException e) {
            return new String(LocaleStrings.GetString("3_2_SSLWRAPPER") + e.getMessage());
        }
        this.engine = context.createSSLEngine();
        this.engine.setUseClientMode(true);
        this.session = this.engine.getSession();
        if (this.setupBuffers() != 0) {
            return new String(LocaleStrings.GetString("3_3_SSLWRAPPER"));
        }
        try {
            this.engine.beginHandshake();
            while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                Runnable runnable;
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    this.netOut.clear();
                    this.engine.wrap(this.appOut, this.netOut);
                    this.netOut.flip();
                    this.m_SocketChannel.write(this.netOut);
                    continue;
                }
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    if (this.netIn.position() == 0) {
                        this.m_SocketChannel.read(this.netIn);
                    }
                    this.netIn.flip();
                    this.engine.unwrap(this.netIn, this.appIn);
                    this.netIn.compact();
                    continue;
                }
                if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                while ((runnable = this.engine.getDelegatedTask()) != null) {
                    runnable.run();
                }
            }
        }
        catch (SSLException e) {
            return new String(LocaleStrings.GetString("3_4_SSLWRAPPER"));
        }
        Debug.out.println("Handshaking is complete!");
        if (this.netIn.position() != 0) {
            Debug.out.println("Extra data along with handshake data " + this.netIn.position());
            this.resetReadBuffer();
            this.decryptData();
        } else {
            this.appIn.position(0);
            this.appIn.limit(0);
        }
        return null;
    }

    public void resetReadBuffer() {
        this.appIn.clear();
    }

    private int decryptData() throws IOException {
        int retvalue = 0;
        if (this.engine != null) {
            boolean done = false;
            SSLEngineResult result = null;
            while (!done) {
                this.netIn.flip();
                result = this.engine.unwrap(this.netIn, this.appIn);
                this.netIn.compact();
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    done = true;
                } else if (result.getStatus() == SSLEngineResult.Status.OK) {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.executeDelegatedTask(this.engine);
                    }
                } else if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    Debug.out.println("unwrap returned BUFFER_OVERFLOW. Need to allocate more memory for appIn");
                } else {
                    throw new IOException(LocaleStrings.GetString("3_5_SSLWRAPPER"));
                }
                if (this.netIn.position() != 0) continue;
                done = true;
            }
            this.appIn.flip();
        }
        return retvalue;
    }

    public int read() throws IOException {
        this.m_SocketChannel.read(this.netIn);
        return this.decryptData();
    }

    public int GetBytes(ByteBuffer in_buffer) throws IOException {
        int num_source_bytes = this.appIn.remaining();
        int dest_bytes_limit = in_buffer.remaining();
        int old_src_limit = this.appIn.limit();
        if (num_source_bytes > dest_bytes_limit) {
            this.appIn.limit(this.appIn.position() + dest_bytes_limit);
        }
        try {
            in_buffer.put(this.appIn);
        }
        catch (BufferOverflowException e) {
            System.out.println("CARE TAKEN TO AVOID THIS EXCEPTION. THIS EXCEPTION SHOULD NOT COME.");
        }
        if (num_source_bytes > dest_bytes_limit) {
            this.appIn.limit(old_src_limit);
        }
        return num_source_bytes > dest_bytes_limit ? dest_bytes_limit : num_source_bytes;
    }

    public int GetBytesRemaining() {
        return this.appIn.remaining();
    }

    public int write(ByteBuffer out_buffer) throws IOException {
        this.appOut.clear();
        this.netOut.clear();
        if (this.engine != null) {
            while (out_buffer.hasRemaining()) {
                this.netOut.clear();
                SSLEngineResult result = this.engine.wrap(out_buffer, this.netOut);
                this.netOut.flip();
                while (this.netOut.hasRemaining() && this.m_SocketChannel.write(this.netOut) != -1) {
                }
            }
        } else {
            while (this.netOut.hasRemaining() && this.m_SocketChannel.write(this.netOut) != -1) {
            }
        }
        return 0;
    }

    public SSLEngineResult.HandshakeStatus executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return sslEngine.getHandshakeStatus();
    }
}

