/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb;

import com.ami.iusb.RedirProtocolException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.SMCUtil;
import com.ami.iusb.protocol.CDROMProtocol;
import com.ami.iusb.protocol.IUSBHeader;
import com.ami.iusb.protocol.IUSBSCSI;
import com.ami.iusb.protocol.PacketMaster;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CDROMRedir
extends Thread {
    JViewerApp app;
    private PacketMaster packetMaster;
    private CDROMProtocol protocol;
    private ByteBuffer packetReadBuffer;
    private ByteBuffer packetWriteBuffer;
    private boolean physicalDrive;
    private boolean running = false;
    private boolean stopRunning = false;
    private long nativeReaderPointer = -1L;
    private Thread redirThread;
    private String sourceCDROM = null;
    private int nBytesRedirected = 0;
    private static final int PORT = 5120;
    private static final int START_LOCAL_IMAGE_REDIRECTION = 240;
    private static final int DEVICE_REDIRECTION_ACK = 241;
    public static final int AUTH_CMD = 242;
    private static final int TRANSFER_CMD = 243;
    private static final int CONNECTION_ACCEPTED = 1;
    private static final int CONNECTION_DENIED = 2;
    private static final int LOGIN_FAILED = 3;
    private static final int CONNECTION_IN_USE = 4;
    private static final int CONNECTION_PERM_DENIED = 5;
    private static final int OTHER_ERROR = 6;
    private static final int MEDIA_IN_DETACH_STATE = 7;
    private static final int MAX_READ_SECTORS = 64;
    private static final int MAX_READ_SIZE = 131072;

    public CDROMRedir(boolean physicalDrive, JViewerApp app) {
        this.app = app;
        this.physicalDrive = physicalDrive;
        this.protocol = new CDROMProtocol();
        this.packetReadBuffer = ByteBuffer.allocateDirect(0x800000);
        this.packetWriteBuffer = ByteBuffer.allocateDirect(131133);
    }

    private void cdromConnect(String host, int port, boolean useSSL) throws IOException {
        this.packetMaster = new PacketMaster(host, port, false, this.protocol, useSSL);
        this.packetMaster.setupBuffers(this.packetReadBuffer, this.packetWriteBuffer);
        this.packetMaster.setBufferEndianness(ByteOrder.LITTLE_ENDIAN, ByteOrder.LITTLE_ENDIAN);
        this.packetMaster.connect();
    }

    private void cdromDisconnect() {
        try {
            this.packetMaster.close();
        }
        catch (IOException e) {
            System.err.println(LocaleStrings.GetString("4_2_CDROMREDIR") + e.getMessage());
        }
    }

    public boolean startRedirection(String host, int port, boolean useSSL, String session_token, String cdromDrive) throws RedirectionException {
        block17: {
            if (this.running) {
                return true;
            }
            try {
                this.cdromConnect(host, port, useSSL);
                this.SendAuth_SessionToken(session_token);
                Debug.out.println("waiting to receive request");
                IUSBSCSI request = this.recvRequest();
                Debug.out.println("out of receive request");
                if (request.opcode == 241) {
                    if (request.connectionStatus != 1) {
                        this.cdromDisconnect();
                        if (request.connectionStatus == 5) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_3_CDROMREDIR"));
                        } else if (request.connectionStatus == 7) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_10_CDROMREDIR"));
                        } else if (request.connectionStatus == 3) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_11_CDROMREDIR"));
                        } else if (request.m_otherIP != null) {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_4_CDROMREDIR") + request.m_otherIP);
                        } else {
                            this.app.generalErrorMessage(LocaleStrings.GetString("4_5_CDROMREDIR"));
                        }
                        return false;
                    }
                    break block17;
                }
                this.cdromDisconnect();
                throw new RedirProtocolException(LocaleStrings.GetString("4_6_CDROMREDIR") + request.opcode);
            }
            catch (IOException e) {
                Debug.out.println("Exception CDROMRedir:startRedirection");
                throw new RedirectionException(e.getMessage());
            }
        }
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(this.physicalDrive);
        }
        this.sourceCDROM = cdromDrive;
        try {
            if (!this.openCDROM(cdromDrive.getBytes("UTF-8"))) {
                System.err.println(LocaleStrings.GetString("4_7_CDROMREDIR"));
                this.deleteCDROMReader();
                this.cdromDisconnect();
                return false;
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Path UTF-8 encoding error!");
        }
        this.nBytesRedirected = 0;
        this.redirThread = new Thread(this);
        this.redirThread.start();
        this.running = true;
        return true;
    }

    public boolean stopRedirection() {
        if (this.running) {
            this.stopRunning = true;
            try {
                this.packetMaster.wakeup();
                this.redirThread.join();
            }
            catch (InterruptedException e) {
                System.err.println(LocaleStrings.GetString("4_8_CDROMREDIR"));
            }
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
        }
        this.nBytesRedirected = 0;
        return true;
    }

    private IUSBSCSI recvRequest() throws IOException, RedirectionException {
        return (IUSBSCSI)this.packetMaster.receivePacket();
    }

    public boolean isRedirActive() {
        return this.running;
    }

    public void stopRedirectionAbnormal() {
        if (this.running) {
            this.stopRunning = true;
            this.cdromDisconnect();
            this.running = false;
            this.stopRunning = false;
            this.closeCDROM();
            this.deleteCDROMReader();
            this.app.reportCDROMAbnormal();
        }
    }

    @Override
    public void run() {
        int nTempLen = 0;
        while (!this.stopRunning) {
            try {
                this.packetWriteBuffer.rewind();
                IUSBSCSI request = this.recvRequest();
                if (request == null) continue;
                int dataLen = this.executeCDROMSCSICmd(this.packetReadBuffer, this.packetWriteBuffer);
                this.packetWriteBuffer.limit(dataLen);
                IUSBSCSI response = new IUSBSCSI(this.packetWriteBuffer, true);
                this.packetMaster.sendPacket(response);
                this.nBytesRedirected += (nTempLen += dataLen) / 1024;
                nTempLen %= 1024;
            }
            catch (IOException e) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(e.getMessage());
                return;
            }
            catch (RedirectionException e) {
                if (this.stopRunning) continue;
                this.stopRedirectionAbnormal();
                this.handleError(e.getMessage());
                return;
            }
        }
        Debug.out.println("Exiting the CDROM/ISO Redirection thread");
    }

    public String[] getCDROMList() throws RedirectionException {
        if (!this.physicalDrive) {
            this.DisplayErrorMsg(LocaleStrings.GetString("4_9_CDROMREDIR"));
            return null;
        }
        String[] cdromlist = null;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(true);
            cdromlist = this.listCDROMDrives();
            this.deleteCDROMReader();
        }
        return cdromlist;
    }

    public String getLIBCDROMVersion() {
        String version;
        if (this.nativeReaderPointer == -1L) {
            this.newCDROMReader(false);
            version = this.getVersion();
            this.deleteCDROMReader();
        } else {
            version = this.getVersion();
        }
        return version;
    }

    public void DisplayErrorMsg(String str) {
        this.app.generalErrorMessage(str);
    }

    public void handleError(String str) {
        this.DisplayErrorMsg(str);
    }

    public boolean isPhysicalDevice() {
        return this.physicalDrive;
    }

    public String getSourceDrive() {
        return this.sourceCDROM;
    }

    public void SendAuth_SessionToken(String session_token) throws RedirectionException, IOException {
        int dataLen = 128;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(160);
        IUSBHeader AuthPktIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        AuthPktIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-14);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.put((byte)0);
        this.packetWriteBuffer.put(session_token.getBytes());
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public void sendTransferCmd() throws RedirectionException, IOException {
        int dataLen = 30;
        this.packetWriteBuffer.clear();
        this.packetWriteBuffer.limit(62);
        IUSBHeader transferCmdIUSBHeader = IUSBHeader.createCDROMHeader(dataLen);
        transferCmdIUSBHeader.write(this.packetWriteBuffer);
        this.packetWriteBuffer.position(41);
        this.packetWriteBuffer.put((byte)-13);
        this.packetWriteBuffer.position(62);
        this.packetWriteBuffer.position(0);
        IUSBSCSI pkt = new IUSBSCSI(this.packetWriteBuffer, true);
        this.packetMaster.sendPacket(pkt);
    }

    public int getBytesRedirected() {
        return this.nBytesRedirected;
    }

    private native String[] listCDROMDrives();

    private native void newCDROMReader(boolean var1);

    private native void deleteCDROMReader();

    private native boolean openCDROM(byte[] var1);

    private native void closeCDROM();

    private native int executeCDROMSCSICmd(ByteBuffer var1, ByteBuffer var2);

    private native String getVersion();

    static {
        String systemType = System.getProperty("os.name");
        String libExtension = "";
        String libFullName = "";
        libExtension = System.getProperty("os.arch").indexOf("64") != -1 ? "64" : "32";
        libFullName = systemType.startsWith("Windows") ? "javacdromwrapper" + libExtension + ".dll" : "libjavacdromwrapper" + libExtension + ".so";
        File file = new File(libFullName);
        if (file.exists()) {
            try {
                System.loadLibrary("javacdromwrapper" + libExtension);
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println(LocaleStrings.GetString("4_1_CDROMREDIR"));
            }
        } else {
            try {
                SMCUtil.loadLib("javacdromwrapper" + libExtension);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

