;
; Musical Instrument Digital Interface
; Assembler routines for an OS/2 Device
; Driver written in C.
;
; Copyright Carl M. Benda 1991

        EXTRN   _main:near
        EXTRN   _DevHlp:dword
        EXTRN   _interrupt_handler:near
        PUBLIC  _STRAT
        PUBLIC  _INT_HNDLR
        PUBLIC  _SetIRQ
        PUBLIC  _ReadBytes
        PUBLIC  _WriteBytes
        PUBLIC  _int3
        PUBLIC  __acrtused

_DATA   segment word public 'DATA'
_DATA   ends

CONST   segment word public 'CONST'
CONST   ends

_BSS    segment word public 'BSS'
_BSS    ends

DGROUP  group   CONST, _BSS, _DATA

_TEXT   segment word public 'CODE'

ASSUME  cs:_TEXT, ds:DGROUP, es:NOTHING, ss:NOTHING




.286P

;
;       C startup routine for mididrv.c
;       _Strat is called by OS/2 during
;       boot time.
;

_STRAT  proc    far
__acrtused:             ;prevent startup C
        push    0       ;used as the dev value
        push    es      ;send request packet address
        push    bx
        call    _main   ;call driver main function
        pop     bx      ;restore bx
        pop     es      ;restore es
        add     sp,2    ;get rid of pushed 0
        retf

_STRAT  endp


_INT_HNDLR proc far
        pusha           ;save registers
        push    ds
        push    es
        call    _interrupt_handler  ;handle interrupts
        mov     al,9h   ;int value  ;interrupt number.
        mov     dl,31h  ;devhlp EOI ;DevHlp End of int
        call    [_DevHlp]           ;call DevHlp entry
        pop     es
        pop     ds
        popa            ;restore everything
        retf            ;return to C function.

_INT_HNDLR endp

;
; These next routines are used by the C code
; because these procedures need to call special
; device driver helper routines requiring
; hardware registers of specific values.
;

_SetIRQ   proc  near
        push    bp
        mov     bp,sp
;       flag    located at bp + 8
;       fnc     located at bp + 6
;       irq     irq number at + 4

        mov     bx,WORD PTR [bp+4]      ;irq number
        mov     ax,WORD PTR [bp+6]      ;fnc entry
        mov     dh,BYTE PTR [bp+8]      ;share flag
        mov     dl,1Bh                  ;SetIRQ DevHlp
        call    [_DevHlp]
        leave
        ret

_SetIRQ ENDP

_ReadBytes proc near
        push    bp
        mov     bp,sp
        pusha
        push    es
        push    ds

;       Physical Offset  =  4
;       Physical Segment =  6
;       Device   Driver  =  8
;       count            = 12

        mov     ax,WORD PTR [bp+6]
        mov     bx,WORD PTR [bp+4]
        mov     dl,15h                  ;PhysToVirt
        mov     dh,01h                  ;result in es:di
        call    [_DevHlp]               ;useable addr.

        lds     si,DWORD PTR [bp+ 8]    ;source
        mov     cx, WORD PTR [bp+12]    ;bytes to move
        rep     movsb                   ;copy data!

        mov     dl,32h                  ;Must UnPhys!
        call    [_DevHlp]

        pop     ds
        pop     es
        popa
        leave
        ret

_ReadBytes ENDP

_WriteBytes proc near
        push    bp
        mov     bp,sp
        pusha
        push    es
        push    ds

;       Physical Offset  =  4
;       Physical Segment =  6
;       Device   Driver  =  8
;       count            = 12

        mov     ax,WORD PTR [bp+6]
        mov     bx,WORD PTR [bp+4]
        mov     dl,15h                  ;PhysToVirt
        mov     dh,00h                  ;result in ds:si
        call    [_DevHlp]               ;useable addr.

        les     di,DWORD PTR [bp+ 8]    ;source
        mov     cx, WORD PTR [bp+12]    ;bytes to move
        rep     movsb                   ;copy data!

        mov     dl,32h                  ;Must UnPhys!
        call    [_DevHlp]

        pop     ds
        pop     es
        popa
        leave
        ret

_WriteBytes ENDP

_int3   proc    near
        int     3
        ret
_int3   endp

_TEXT   ends
        end

