.radix	16
.model	tiny
.code
	org	0
start:	dd	0ffffffffh
	dw	8000
	dw	strategy
	dw	interrupt
strategy:mov	word ptr cs:req,bx
	mov	word ptr cs:req+2,es
	retf
	db	8 dup(0)
req	dd	?
interrupt:push	es
	push	ax
	push	bx
	les	bx,cs:req
	mov	word ptr es:[bx+3],100
	mov	word ptr es:[bx+0e],0
	mov	word ptr es:[bx+0e+2],cs
	mov	bx,0d000
	call	Write_Reg
	mov	bx,0d202
	call	Write_Reg
	mov	bh,0c1
	call	Read_Reg
	or	bl,11001111b
	call	Write_Reg
	mov	bh,0cc
	call	Read_Reg
	or	bl,00110000b
	call	Write_Reg
	mov	bh,0cdh
	mov	bl,01011111b
	call	Write_Reg
	mov	bx,0ceff
	call	Write_Reg
	pop	bx
	pop	ax
	pop	es
	retf
;******************************************************************************
;   Read chipset register
; Input:  bh - register number
; Output: bl - value
; Modify: none
;******************************************************************************
Read_Reg proc	near
	push	ax
	push	dx
	mov	dx,8022
	mov	al,0a0
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	mov	al,5
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	mov	al,bh
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	inc	dx
	inc	dx
	in	al,dx
	mov	bl,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	dec	dx
	dec	dx
	mov	al,0
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	pop	dx
	pop	ax
	ret
endp
;******************************************************************************
;   Write chipset register
; Input:  bh - register number
; Output: bl - value
; Modify: none
;******************************************************************************
Write_Reg proc	near
	push	ax
	push	dx
	mov	dx,8022
	mov	al,0a0
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	mov	al,5
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	mov	al,bh
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	inc	dx
	inc	dx
	mov	al,bl
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	dec	dx
	dec	dx
	mov	al,0
	out	dx,al
	jmp	$+2
	jmp	$+2
	out	0ea,ax
	out	0ec,al
	jmp	$+2
	jmp	$+2
	pop	dx
	pop	ax
	ret
endp
end	start
