;$Author:   BCRANE  $
;$Date:   09 Jul 1992 16:41:02  $
;$Header:   W:/sccs/mixers/dialoga.asv   1.2   09 Jul 1992 16:41:02   BCRANE  $
;$Log:   W:/sccs/mixers/dialoga.asv  $
;  
;     Rev 1.2   09 Jul 1992 16:41:02   BCRANE
;  changed jnc to jc in _dlgflush...
;  
;     Rev 1.1   23 Jun 1992 16:46:26   DCODY
;  PAS2 update
;  
;     Rev 1.0   15 Jun 1992 09:41:22   BCRANE
;  Initial revision.
;$Logfile:   W:/sccs/mixers/dialoga.asv  $
;$Modtimes$
;$Revision:   1.2  $

        Title Media Vision Dialog Video backup code
	page	64,131

	;; modified to support large model, June 19,1991 Kevin Norman

;   /*\
;---|*|----====< DIALOGA.ASM >====----
;---|*|
;---|*| Initialize and setup the access to the mixers, volume, filter, etc
;---|*|
;   |*|  Media Vision, Inc. Copyright (c) 1991, All Rights Reserved
;---|*|
;   \*/

	.xlist
	include model.inc
        include masm.inc
;;;;;;;;include target.inc
        .list

if MODELSIZE eq 0
	.code
else
	.data
endif

NumLockState	db	0		; holds the NumLock state
lasttime	dw	0		; holds the last clock tic

        public  leftvolume
leftvolume	dw	0
	public	leftswitch
leftswitch	db	0
	public	ritvolume
ritvolume	dw	0
	public	ritswitch
ritswitch	db	0
	public	VolumeNumber
VolumeNumber	dw	0
	public	VolumeSwitch
VolumeSwitch    db      0
	public	Left2LeftState
Left2LeftState  dw      0
	public	Left2RightState
Left2RightState dw	0
	public	Right2LeftState
Right2LeftState dw	0
	public	Right2RightState
Right2RightState dw	 0

        .code


;   /*\
;---|*|----====< DecodeCrossChannel ( char * ) >====----
;---|*|
;---|*| Back up the whole thing
;---|*|
;   \*/
	public	DecodeCrossChannel
DecodeCrossChannel proc
	push	bp
	mov	bp,sp
	push	es
	push	si

if @datasize
	les	si,dParm1
else
	push	ds
	pop	es
	mov	si,wParm1
endif

	cld

        lods    byte ptr es:[si]
	inc	si
	cmp	al,02dh 		; '-'
        sbb     ax,ax                   ; ax = -1 if '+'
	mov	Left2LeftState,ax

	lods	byte ptr es:[si]
	inc	si
	cmp	al,02dh 		; '-'
	sbb	ax,ax
	mov	Left2RightState,ax

	lods	byte ptr es:[si]
	inc	si
	cmp	al,02dh 		; '-'
	sbb	ax,ax
	mov	Right2LeftState,ax

	lods	byte ptr es:[si]
	cmp	al,02dh 		; '-'
	sbb	ax,ax
	mov	Right2RightState,ax

	pop	si
        pop     es
	pop	bp
	ret

DecodeCrossChannel endp


;   /*\
;---|*|----====< DecodeMixer ( char * ) >====----
;---|*|
;---|*| Back up the whole thing
;---|*|
;   \*/
	public	DecodeMixer
DecodeMixer	proc
	push	bp
	mov	bp,sp
	push	es
	push	si

if @datasize
	les	si,dParm1
else
	push	ds
	pop	es
	mov	si,wParm1
endif

	cld

	call	FFAR ptr getnumber	; get the percentage
	jc	demi_bad
	mov	leftvolume,ax

	lodsb				; get the switch
	mov	leftswitch,al
	inc	si			; move past the tab

	call	FFAR ptr getnumber	; get the percentage
	jc	demi_bad
	mov	ritvolume,ax

	lodsb				; get the switch
	mov	ritswitch,al
;
demi_bad:
	pop	si
        pop     es
	pop	bp
	ret

DecodeMixer	endp


;   /*\
;---|*|----====< DecodeVolumeNumber ( char * ) >====----
;---|*|
;---|*| Back up the whole thing
;---|*|
;   \*/
	public	DecodeVolumeNumber
DecodeVolumeNumber    proc
	push	bp
	mov	bp,sp
	push	es
	push	si

if @datasize
	les	si,dParm1		;*****
else
	push	ds
	pop	es
	mov	si,wParm1
endif

	cld
	call	FFAR ptr getnumber	; get the percentage
	jc	devn_bad
	mov	VolumeNumber,ax
;
devn_bad:
	pop	si
        pop     es			;*****
	pop	bp
	ret

DecodeVolumeNumber	endp


;   /*\
;---|*|----====< DecodeVolumeSwitch ( char * ) >====----
;---|*|
;---|*| Back up the whole thing
;---|*|
;   \*/
	public	DecodeVolumeSwitch
DecodeVolumeSwitch    proc
	push	bp
	mov	bp,sp
	push	es
	push	si
if @datasize
	les	si,dParm1
else
	push	ds
	pop	es
	mov	si,wParm1
endif

	cld

	lods	byte ptr es:[si]
	mov	VolumeSwitch,al

        pop     si
        pop     es			;*****
	pop	bp
	ret

DecodeVolumeSwitch	endp


;   /*\
;---|*|----====< _dlgflushfile (int handle) >====----
;---|*|
;---|*| This function makes a duplicate file handle, then
;---|*| closes the duplicate. This forces the file to be flushed.
;---|*|
;   \*/
	public	_dlgflushfile
_dlgflushfile	proc
	push	bp
	mov	bp,sp

	mov	bx,wParm1
	mov	ah,45h
	int	21h
	jc	thisisbad

	mov	bx,ax
	mov	ah,3eh
	int	21h

thisisbad:
	pop	bp
	ret

_dlgflushfile	endp


;   /*\
;---|*|----====< _dlggettimedelta() >====----
;---|*|
;---|*| This function returns a 0 or 1 if a clock tic occured
;---|*|
;   \*/
	public	_dlggettimedelta
_dlggettimedelta       proc
	mov	ah,0
	int	1Ah
	sub	ax,ax
	cmp	lasttime,dx	    ; ax = delta of current/last time
	mov	lasttime,dx
	adc	ax,0
	ret

_dlggettimedelta  endp


;   /*\
;---|*|----====< _dlgrestorenumlock ( ) >====----
;---|*|
;---|*| This function restores the numlock state
;---|*|
;   \*/
	public	_dlgrestorenumlock
_dlgrestorenumlock	proc
	push	es			; save es

        sub     ax,ax
	mov	es,ax

        mov     al,NumLockState
	or	es:[417h],al		; possibly set it

        pop     es
	ret

_dlgrestorenumlock      endp


;   /*\
;---|*|----====< _dlgsavenumlock ( ) >====----
;---|*|
;---|*| This function restores the numlock state
;---|*|
;   \*/
	public	_dlgsavenumlock
_dlgsavenumlock proc
	push	es				; save the numlock state

        sub     ax,ax
	mov	es,ax

	mov	al,20h
	and	al,es:[417h]
	and	byte ptr es:[417h],0dfh 	; clear it...
	mov	NumLockState,al

        pop     es
	ret

_dlgsavenumlock endp


;   /*\
;---|*|----====< getnumber ( char far * ) >====----
;---|*|
;---|*| convert ASCII # into binary
;---|*|
;---|*| entry conditions:
;---|*|    ES:SI points to the string
;---|*|
;---|*| Exit Conditions:
;---|*|    AX holds a number
;---|*|    SI points past the non-numeric character
;---|*|
;   \*/

getnumber	proc
	cld
	sub	bx,bx
	sub	ax,ax
;
genu_05:
	lods	byte ptr es:[si]
	sub	al,30h
	jb	genu_done
	cmp	al,9
	ja	genu_done
	shl	bx,1			; bx = bx * 2
	mov	cx,bx
	shl	bx,1			; bx = bx * 4
	shl	bx,1			; bx = bx * 8
	add	bx,cx			; bx = bx * 10
	add	bx,ax
	jmp	short genu_05
;
genu_done:
	mov	ax,bx
	clc
        ret

getnumber	endp


;   /*\
;---|*| end of DIALOGA.ASM
;   \*/

        end

