#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#define OKAY 0

#include "cdmaster.h"

char *syntax= "Syntax: cdstatus [drive #].\n";
char *nodrives= "No CDROM drives attached.\n";
char *nomscdex= "MSCDEX is not installed.\n";

int SPECIFIEDIT;
char cdu[26];

main(int argc, char **argv)
{
	int numcdroms= 0;
	int ourdrive= 0;
	struct cdtable *cdt;

	if (!ismscdex())
		{
		fprintf(stderr, nomscdex);
		return(1);
		}

	if (!(numcdroms= getnumcdroms()))
		{
		fprintf(stderr, nodrives);
		return(2);
		}

	getcdromunits(cdu);

	switch (argc)
		{
		case 2:
			SPECIFIEDIT= 1;
			if (!(ourdrive= atoi(argv[1])))
				{
				fprintf(stderr, syntax);
				return(3);
				}
			break;

		case 1:
			if (!(ourdrive= getfirstcdrom()))
				{
				fprintf(stderr, nodrives);
				return(4);
				}
			break;

		default:
			fprintf(stderr, syntax);
			return(5);
		}

	if (SPECIFIEDIT)
		{
		printf("status drive: %2d ", ourdrive);

		if (cdt= createaudiotoc(ourdrive))
			{
			int status= cdstatus(ourdrive);
			if (!status)
				printf("nonexistent.\n");
			else
				printf("= %X: Playing: %s, Paused: %s.\n",
					status,
					status& CDISPLAYING ? "yes" : "no",
					status& CDISPAUSED ? "yes" : "no");
			destroyaudiotoc(ourdrive);
			}
		else
			printf("failed, no initialization.\n");
		return(OKAY);
		}

		{
		int i;

		for (i= 0; i < 26; i++)
			{
			if (cdu[i])
				{
				ourdrive= (int) cdu[i];
				printf("status drive: %2d ", ourdrive);

				if (cdt= createaudiotoc(ourdrive))
					{
					int status= cdstatus(ourdrive);
					if (!status)
						printf("nonexistent.\n");
					else
						printf("= %X: Playing: %s, Paused: %s.\n",
							status,
							status& CDISPLAYING ? "yes" : "no",
							status& CDISPAUSED ? "yes" : "no");
					destroyaudiotoc(ourdrive);
					}
				else
					printf("failed, no initialization.\n");
				}
			}
		}

	

	return(OKAY);
}

