;$Author:   BCRANE  $
;$Date:   15 Jun 1992 10:16:14  $
;$Header:   W:/sccs/inc/play.inv   1.0   15 Jun 1992 10:16:14   BCRANE  $
;$Log:   W:/sccs/inc/play.inv  $
;
;   Rev 1.0   15 Jun 1992 10:16:14   BCRANE
;Initial revision.
;$Logfile:   W:/sccs/inc/play.inv  $
;$Modtimes$
;$Revision:   1.0  $
;$Workfile:   PLAY.INC  $ 


;
;   /*\
;---|*|----=====< PLAY.INC >====----
;---|*|
;---|*|  This module holds the various definitions for the
;---|*|  ".VOC" file contents.
;---|*|
;---|*| Copyright (c) 1991, Media Vision, Inc.	All Rights Reserved.
;---|*|
;   \*/


;   /*\
;---|*| Sound Blaster ".VOC" file definition
;   \*/

;		----====< Header portion of the .VOC >====----

VOCHDR struc
 vhid		db	20 dup(?)	;  name
 vhvoice_offset dw	?		;  offset to data block
 vhversion	dw	?		;  version
 vhcheck_code	dw	?		;  garbage
VOCHDR ends

;		----====< types of data blocks >====----

TERMINATOR	equ	00		;  terminator block type
VOICEDATA	equ	01		;  voice data block
VOICECONTINUE	equ	02		;  more voice data block
SILENCE 	equ	03		;  silence period
MARKER		equ	04		;  marker for syncing
ASCIITEXT	equ	05		;  ascii zstring data
REPEAT		equ	06		;  repeat next blocks x times
ENDREPEAT	equ	07		;  end repeat marker

;		----====< Common Header to each data block >====----

bVOCDATAHDR struc
 bxbtype	db	?		;  block type
 bxbsize	db	3 dup(?)	;  24 bits for block size
bVOCDATAHDR ends

;		----====< voice data block (#1) >====----

bVOCDATA struc
 b1btype	db	?		;  block type
 b1bsize	db	3 dup(?)	;  24 bits for block size
 b1sampler	db	?		;  sample rate
 b1packtype	db	?		;  packing 8/4/2.6/2 bits
bVOCDATA ends

;		----====< voice continuation (#2) >====----

bCONTINUE struc
 b2btype	db	?		;  block type
 b2bsize	db	3 dup(?)	;  24 bits for block size
bCONTINUE ends

;		----====< Silence (#3) >====----

bSILENCE struc
 b3btype	db	?		;  block type
 b3bsize	db	3 dup(?)	;  24 bits for block size
 b3period	dw	?		;  period in sample units
 b3sampler	db	?		;  sample rate
bSILENCE ends

;		----====< Marker (#4) >====----

bMARKER struc
 b4btype	db	?		;  block type
 b4bsize	db	3 dup(?)	;  24 bits for block size
 b4marker	dw	?		;  marker ID
bMARKER ends

;		----====< ASCII zstring text (#5) >====----

bASCII	struc
 b5btype	db	?		;  block type
 b5bsize	db	3 dup(?)	;  24 bits for block size
 b5text 	db	?		;  ascii zstring text
bASCII	ends


;		----====< Repeat Loop (#6) >====----

bREPEAT struc
 b6btype	db	?		;  block type
 b6bsize	db	3 dup(?)	;  24 bits for block size
 b6count	dw	?		;  # of times to repeat (-1)
bREPEAT ends

;		----====< End Repeat Loop (#7) >====----

bENDREP struc
 b7btype	db	?		;  block type
 b7bsize	db	3 dup(0)	;  24 bits for block size
bENDREP ends


;
;   /*\
;---|*|----====< ".WAV" file definition >====----
;---|*|
;---|*|     4 bytes 'RIFF'
;---|*|     4 bytes <length>
;---|*|     4 bytes 'WAVE'
;---|*|     4 bytes 'fmt '
;---|*|     4 bytes  <length>		; 10h - length of 'data' block
;---|*|     2 bytes  01 		; format tag
;---|*|     2 bytes  01 		; channels (1=mono, 2=stereo)
;---|*|     4 bytes  xxxx		; samples per second
;---|*|     4 bytes  xxxx		; average samples per second
;---|*|     2 bytes  01 		; block alignment
;---|*|     2 bytes  08 		; bits per sample
;---|*|     4 bytes 'data'
;---|*|     4 bytes <length>
;---|*|       bytes <sample data>
;---|*|
;   \*/
;

;		 ----====< Wave format control block >====----

WaveInfo struc
 wiformatTag		dw	?	;  format category		*/
 winChannels		dw	?	;  stereo/mono			*/
 winSamplesPerSec	dd	?	;  sample rate			*/
 winAvgBytesPerSec	dd	?	;  stereo * sample rate 	*/
 winBlockAlign		dw	?	;  block alignment (1=byte)	*/
 winBitsPerSample	dw	?	;  # byte bits per sample	*/
WaveInfo ends

WaveFormat struc
 wfname 	db	4 dup(?)
 wflength	dd	?
 wfinfo 	db	size WaveInfo dup(?)
WaveFormat ends

;      ----====< Data header which follows a WaveFormat Block >====----

DataHeader struc;
 dhname 	db	4 dup(?)
 dhlength	dd	?
DataHeader ends

;	   ----====< Total Wave Header data in a wave file >====----

WaveHeader struc;
 whname 	db	4 dup(?)
 whfmt		db	size WaveFormat dup(?)
 whdata 	db	size DataHeader dup(?)
WaveHeader ends;

;    ----====< Riff wrapper around the WaveFormat Block (optional) >====----

RiffHeader struc
 rhname 	db	4 dup(?)
 rhlength	dd	?
RiffHeader ends

;		----====< Riff wrapped WaveFormat Block >====----

RiffWave struc;
 rwriff 	db	size RiffHeader dup(?)
 rwwave 	db	size WaveHeader dup(?)
RiffWave ends

;
;   /*\
;---|*| end of PLAY.INC
;   \*/
;
