#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _modfstruct
*/

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define BUFFER_SIZE 12	/* parameters buffer size in words */

#ifdef ANSI
void FTYPE modfstruct(short p0, short p1, short p2, short p3, short _I_PTYPE *p4)
#else
FTYPE modfstruct(p0, p1, p2, p3, p4)
short p0;
short p1;
short p2;
short p3;
short _I_PTYPE *p4;
#endif
{
	unsigned long _I_PTYPE *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

	/* set buffer for parameters */
	p = i_buff;

    *p++ = (SECOND_DEC | MODFSTRUCT);
    *p++ = (long) p0;
    *p++ = (long) p1;
    *p++ = (long) p2;
    *p++ = (long) p3;
    *p++ = (long)(p2*p3);

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short _I_PTYPE *)p4;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short)(p2*p3);

    /* send buffers */
	ioputmbuf ( i_buffers, i_ns, 2 );
}

