#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _modfmstruct
*/ 

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define BUFFER_SIZE 8 /* parameters buffer size in words */

#ifdef ANSI
void FTYPE modfmstruct(short p0, short p1, short _I_PTYPE *p2)
#else
FTYPE modfmstruct(p0, p1, p2)
short p0;
short p1;
short _I_PTYPE *p2;
#endif
{
    unsigned long *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, *ns;

    /* set buffer for parameters */
    p = i_buff;

    *p++ = (SECOND_DEC | MODFMSTRUCT);
    *p++ = (long) p0;
    *p++ = (long) p1;
    *p++ = (long) p1;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short _I_PTYPE *)p2;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short) p1;

    /* send buffers */
    ioputmbuf ( i_buffers, i_ns, 2 );
}
