/*/  Function name:   v2gpunmp
*
*    Note:  Use the C binding's "iogetf" function to retrieve the data.
*           The x virtual coordinate is read first, then the y virtual
*           coordinate.
*
*    Author:   Jean Dupre
*    Date:     Oct 1, 1987
*
*    Modification history:  
*
*    Calls:  ioputbuf:  send a buffer to the board.
*
*    Uses:  None
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE v2gpunmp(short x, short y)
#else
FTYPE v2gpunmp(x, y)
short  x, y;
#endif

    {
    ptrbuff = buff;

    *ptrbuff++ = 0x0094;
    *ptrbuff++ = x;
    *ptrbuff = y;
    
    ioputbuf(buff, 3);
    }


