/*/  Function name:   v2txbstring
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:
*M      PG,   90.11.22, char should be unsigned.
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*            ioputtxt:  send a text string to the board.
*
*    Uses:  FIXTP data type.
*
*    Return value:   None
*/

#include  <string.h>
#include  <stdio.h>
#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;


#ifdef ANSI
void FTYPE v2txbstring(FIXPT x, FIXPT y, unsigned char _I_PTYPE *strptr)
#else
FTYPE v2txbstring(x, y, strptr)
FIXPT  x, y;
unsigned char  _I_PTYPE *strptr;
#endif

    {
    unsigned short  n,length = strlen((char _I_PTYPE *)strptr);

    ptrbuff = buff;

    *ptrbuff++ = 0x008E;
    LDFBUFF(ptrbuff, x);
    LDFBUFF(ptrbuff, y);
    *ptrbuff++ = length;

    if (length > (unsigned short) ( CBUFFLENGTH - 6 ))
        {
#ifndef  I_NOPRINTF
# ifdef I_INTEL		/* fprintf buggy under INTEL Vr4 */
		printf("v2txbstr error : string too long.\n");
# else
		fprintf( stderr, "v2txbstr error : string too long.\n");
# endif /* I_INTEL    */
#else	  /* !I_NOPRINTF */
		  ;
#endif  /* I_NOPRINTF */
        return;
        }

    n = length + 6;

    while (length--)  {
        *ptrbuff++ = (unsigned char) *strptr++;
    }

    ioputbuf(buff, n);
    }


