#include "imseries.h"
#include "imbind.h"
#include "proto.h"

/* 
Copyright (c) Matrox Electronics 1989. All rights reserved
 FUNCTION DEF : _dildlogcam
*/

extern unsigned long i_buff[];
extern unsigned short _I_PTYPE *i_buffers[];
extern unsigned short i_ns[];

#define SIZEOF_CAMERA 112	/* size of array in bytes */

#define BUFFER_SIZE 6 		/* parameters buffer size in words */

#ifdef ANSI
void FTYPE dildlogcam(unsigned short p0, long _I_PTYPE *p1)
#else
FTYPE dildlogcam(p0, p1)
unsigned short p0;
long _I_PTYPE *p1;
#endif
{
	unsigned long _I_PTYPE *p;
	unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;

    /* set buffer for parameters */
    p = i_buff;

    *p++ = (SECOND_DEC | DILDLOGCAM);
    *p++ = (unsigned long) p0;
    *p++ = (unsigned long) (SIZEOF_CAMERA >> 1);

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short *)i_buff;
    /* then the kernel values */
    *buffers = (unsigned short _I_PTYPE *)p1;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = BUFFER_SIZE;
    /* kernel array size ( in words ) */
    *ns = (unsigned short)(SIZEOF_CAMERA >> 1);

    /* send buffers */
    ioputmbuf (i_buffers, i_ns, 2);
}
