/*/  Function name:   v2txstring
*
*    Author:   Jean Dupre
*    Date:     March 17, 1988
*
*    Modification history:
*
*    Calls:  ioputbuf:  send a buffer of words to the board.
*
*    Uses:  FIXPT data type.
*
*    Return value:   None
*/

#include "imseries.h"
#include "imbind.h"
#include "proto.h"

IMPORT  short  buff[];
IMPORT  short  *ptrbuff;
IMPORT  unsigned short _I_PTYPE *i_buffers[];
IMPORT  unsigned short i_ns[];

#define BUFFER_SIZE 6    /* parameters buffer size in words */

#ifdef ANSI
void FTYPE v2txstring(FIXPT x, FIXPT y, short _I_PTYPE *strptr)
#else
FTYPE v2txstring(x, y, strptr)
FIXPT  x, y;
short  _I_PTYPE *strptr;
#endif

    {
	 unsigned short _I_PTYPE * _I_PTYPE *buffers, _I_PTYPE *ns;
    unsigned short  length = 0;
    short  _I_PTYPE *ptrtxt;

    ptrtxt = strptr;

    while (*ptrtxt++)
        length++;

    ptrbuff = buff;

    *ptrbuff++ = 0x008E;
    LDFBUFF(ptrbuff, x);
    LDFBUFF(ptrbuff, y);
    *ptrbuff = length;

    /* set buffer for buffers */
    buffers = i_buffers;
    /* first send  parameters */
    *buffers++ = (unsigned short _I_PTYPE *)buff;
    /* then the structure values */
    *buffers = (unsigned short _I_PTYPE *)strptr;

    /* set buffer for buffer sizes */
    ns = i_ns;
    /* parameter buffer size ( in words ) */
    *ns++ = (unsigned short) BUFFER_SIZE;
    /* structure size ( in words ) */
    *ns = length;

    /* send buffers */
    ioputmbuf(i_buffers, i_ns, 2);

    }


