/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool.locks;

import java.io.Serializable;
import scala.actors.threadpool.locks.CondVar;
import scala.actors.threadpool.locks.Condition;

public class ReentrantLock
implements Serializable,
CondVar.ExclusiveLock {
    private final Sync sync = new NonfairSync();

    public final void lock() {
        this.sync.lock();
    }

    public final boolean tryLock() {
        return this.sync.tryLock();
    }

    public final void unlock() {
        this.sync.unlock();
    }

    public final Condition newCondition() {
        ReentrantLock reentrantLock = this;
        Sync cfr_ignored_0 = reentrantLock.sync;
        return new CondVar(this);
    }

    @Override
    public final boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public final boolean isLocked() {
        return this.sync.isLocked();
    }

    public String toString() {
        ReentrantLock reentrantLock = this;
        Thread o = reentrantLock.sync.getOwner();
        return super.toString() + (o == null ? "[Unlocked]" : "[Locked by thread " + ((Thread)((Object)reentrantLock)).getName() + "]");
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void lock() {
            Thread caller = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                if (caller == this.owner_) {
                    this.incHolds();
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    void var1_1;
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            wasInterrupted = true;
                        }
                    } while (this.owner_ != null);
                    this.owner_ = var1_1;
                    this.holds_ = 1;
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        @Override
        public final synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }
    }

    static abstract class Sync
    implements Serializable {
        protected transient Thread owner_ = null;
        protected transient int holds_ = 0;

        protected Sync() {
        }

        public abstract void lock();

        /*
         * WARNING - void declaration
         */
        final void incHolds() {
            void var1_1;
            int nextHolds = ++this.holds_;
            if (this.holds_ < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.holds_ = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean tryLock() {
            Thread caller = Thread.currentThread();
            Sync sync = this;
            synchronized (sync) {
                void var1_1;
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return true;
                }
                if (var1_1 == this.owner_) {
                    this.incHolds();
                    return true;
                }
            }
            return false;
        }

        public abstract void unlock();

        public final synchronized boolean isHeldByCurrentThread() {
            return this.holds_ > 0 && Thread.currentThread() == this.owner_;
        }

        public final synchronized boolean isLocked() {
            return this.owner_ != null;
        }

        protected final synchronized Thread getOwner() {
            return this.owner_;
        }
    }
}

