// OtherPage.cpp : implementation file
//

#include "stdafx.h"
#include "Total.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COtherPage property page

IMPLEMENT_DYNCREATE(COtherPage, CPropertyPage)

COtherPage::COtherPage() : CPropertyPage(COtherPage::IDD)
{
	//{{AFX_DATA_INIT(COtherPage)
	m_data = _T("");
	m_dataaddr = _T("");
	m_devaddr = _T("50");
	//}}AFX_DATA_INIT
}

COtherPage::~COtherPage()
{
}

void COtherPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COtherPage)
	DDX_Text(pDX, IDC_EDIT_I2CDATA, m_data);
	DDV_MaxChars(pDX, m_data, 2);
	DDX_Text(pDX, IDC_EDIT_I2CDATAADD, m_dataaddr);
	DDV_MaxChars(pDX, m_dataaddr, 2);
	DDX_Text(pDX, IDC_EDIT_I2CDEVADD, m_devaddr);
	DDV_MaxChars(pDX, m_devaddr, 2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COtherPage, CPropertyPage)
	//{{AFX_MSG_MAP(COtherPage)
	ON_BN_CLICKED(IDC_BUTTON_I2CREAD, OnButtonI2cread)
	ON_BN_CLICKED(IDC_BUTTON_I2CWRITE, OnButtonI2cwrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COtherPage message handlers

void COtherPage::OnButtonI2cread()		//I2C
{
	UCHAR mData=0;
	UCHAR mDataAddr=0;
	UCHAR mDevAddr=0;
	UpdateData(TRUE);	
	if(strlen(m_dataaddr) == 0 )
	{
		MessageBox("ݵԪַ","CH341",MB_OK|MB_ICONSTOP);
		return;
	}
	else if(strlen(m_devaddr) == 0)
	{
		MessageBox("豸ַ","CH341",MB_OK|MB_ICONSTOP);
		return;
	}
	if(strlen(m_dataaddr) > 2 || strlen(m_devaddr) > 2)
	{
		MessageBox("豸ַݵԪַӦʮFFH","CH341",MB_OK|MB_ICONSTOP);
		return;
	}
    
	if(strlen(m_dataaddr) > 1)
	{
		mDataAddr = (CPublic::mCharToBcd(m_dataaddr.GetAt(0)) << 4) + (CPublic::mCharToBcd(m_dataaddr.GetAt(1)));
	}
	else 
	{
		mDataAddr = CPublic::mCharToBcd(m_dataaddr.GetAt(0));
	}
	if(strlen(m_devaddr) > 1)
	{
		mDevAddr = (CPublic::mCharToBcd(m_devaddr.GetAt(0)) << 4) + (CPublic::mCharToBcd(m_devaddr.GetAt(1)));
	}
	else
	{
		mDevAddr = CPublic::mCharToBcd(m_devaddr.GetAt(0));
	}
	if(CPublic::m_open)
	{
		if( !CH341ReadI2C( CPublic::mIndex, mDevAddr, mDataAddr, &mData ) )
		{
			MessageBox("I2Cʧܣ","CH341",MB_OK|MB_ICONSTOP);
		}
		else
		{
			CHAR mtemp[4]="";		
			sprintf(&mtemp[0],"%2X",mData);    //λʮһո
			m_data=mtemp;		
			UpdateData(false);		
		}
	}
	else
	{
		MessageBox("豸δ򿪣","CH341",MB_OK|MB_ICONSTOP);
	}
	UpdateData(false);
}

void COtherPage::OnButtonI2cwrite()			//дI2C
{
	UCHAR mData;
	UCHAR mDataAddr;
	UCHAR mDevAddr;
	UpdateData(TRUE);
	
	if(strlen(m_dataaddr) == 0 || strlen(m_devaddr) == 0 || strlen(m_data) == 0)
	{
		MessageBox("豸ַݵԪַ","CH341",MB_OK|MB_ICONSTOP);
		return;
	}
	if(strlen(m_dataaddr) > 2 || strlen(m_devaddr) > 2 || strlen(m_data) > 2)
	{
		MessageBox("豸ַݵԪַʹдݶӦʮFFH","CH341",MB_OK|MB_ICONSTOP);
		return;
	}
	
	if(strlen(m_dataaddr) > 1)
	{
		mDataAddr = (CPublic::mCharToBcd(m_dataaddr.GetAt(0)) << 4) + (CPublic::mCharToBcd(m_dataaddr.GetAt(1)));
	}
	else
	{
		mDataAddr = CPublic::mCharToBcd(m_dataaddr.GetAt(0));
	}
	if(strlen(m_devaddr) > 1)
	{
		mDevAddr = (CPublic::mCharToBcd(m_devaddr.GetAt(0)) << 4) + (CPublic::mCharToBcd(m_devaddr.GetAt(1)));
	}
	else
	{
		mDevAddr = CPublic::mCharToBcd(m_devaddr.GetAt(0));
	}
	if(strlen(m_data) > 1)
	{
		mData = (CPublic::mCharToBcd(m_data.GetAt(0)) << 4) + (CPublic::mCharToBcd(m_data.GetAt(1)));
	}
	else
	{
		mData = CPublic::mCharToBcd(m_data.GetAt(0));
	}
	if(CPublic::m_open)
	{
		if(!CH341WriteI2C( CPublic::mIndex, mDevAddr, mDataAddr, mData))
		{
			MessageBox("I2Cдʧܣ","CH341",MB_OK|MB_ICONSTOP);
		}
		else
		{
			MessageBox("I2Cдݳɹ","CH341",MB_OK|MB_ICONSTOP);			
		} 
	}
	else
	{
		MessageBox("豸δ򿪣","CH341",MB_OK|MB_ICONSTOP);
	}
}


BOOL COtherPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();

	this->enablebtn(CPublic::m_open );    //ʼť

	return TRUE;  
}

void COtherPage::enablebtn( BOOL bEnable )
{
	::EnableWindow(::GetDlgItem(this->GetSafeHwnd(), IDC_BUTTON_I2CREAD), bEnable);
	::EnableWindow(::GetDlgItem(this->GetSafeHwnd(), IDC_BUTTON_I2CWRITE), bEnable);
}
