/********************************** (C) COPYRIGHT *******************************
* File Name          : PARA_MEM.C
* Author             : WCH
* Version            : V1.0
* Date               : 2013/10/12
* Description        : CH563 MEM DEMO
*                      (1)CH563 Examples by KEIL3_V3.53;    
*                      (2)0Ϣ,115200bps,ĬϾ100MHz;
*                      (3)(CH341)MEMģʽݷͣCH563ͨڽ;
                       (4)CH563ݣCH341MEMģʽ½; 
                       (5)ʹõƬʾշʱԽCH341λCH341PAR.EXE;
                       (6)Ƭʱָڲܳ20ns20nsȷ׼ȷ;
                       (7)һ2^32ֽڵݣRECV_NUM趨;
                       (8)һ෢2^32ֽڵݣSEND_NUM趨;
*******************************************************************************/

/*ӿڶ*/
/*******************************************************************************
*ӿڿԸʹõĵƬӦ޸
*PIN				 :CH563(MEM)    DIR      CH341MEM
*                                   PB0         <-          WR                  CH341дѡͨ͵ƽЧ							   	  						   
*                                   PA9         ->          WAIT                CH341ݿ룬͵ƽЧ 
*                                   PA10        <-          A0(AS)              CH341Ƭѡźݡ˿(ߵƽߵ͵ƽ)
                                                                                A0ΪƬѡźŻ߶˿ѡź
*                                   PA8         <-          RD(DS)              CH341ѡͨ͵ƽЧ	   
*                                   PD0~PD7     <->         D0~D7               ˫ݶ˿
*******************************************************************************/

/******************************************************************************/
/* ͷļ */
#define DEBUG                        0                                         /*    */

#include <stdio.h>
#include <string.h>
#include "CH563SFR.H"
#include "SYSFREQ.H"
 
/******************************************************************************/
/*  */
#define RECV_NUM                   512                                         /*ջС*/
#define SEND_NUM                   512                                         /*巢ͻС*/
#define PIN_PA_8_RD                ( 1 << 8 )                                  /* RD(PA8)  */
#define PIN_PA_9_WAIT              ( 1 << 9 )                                  /* WAIT(PA9)*/
#define PIN_PA_10_A0               ( 1 << 10 )                                 /* A0(PA10) */
#define PIN_PB_0_WR                ( 1 << 0 )                                  /* WR(PB0) */

#define PIN_CH341MEM_WR            (R32_PB_PIN&0x001)                          /*ȡPIN_WRŵƽ*/
#define PIN_CH341MEM_RD            (R32_PA_PIN&0x100)                          /*ȡPIN_RDŵƽ*/
#define PIN_CH341MEM_A0            (R32_PA_PIN&0x400)                          /*ȡPIN_A0ŵƽ*/

#define PIN_PWAIT_LOW( )         { R32_PA_CLR |= 0x200; }                      /*PIN_WAIT͵ƽ*/
#define PIN_PWAIT_HIGH( )        { R32_PA_OUT |= 0x200; }                      /*PIN_WAITߵƽ*/
#define PIN_PWAIT_OUT( )         { R32_PA_DIR |= PIN_PA_9_WAIT; }              /*PIN_WAITΪ*/
#define PIN_PWR_IN( )            { R32_PA_DIR &= ~PIN_PB_0_WR; }               /*PIN_WRΪ*/
#define PIN_PA0_IN( )            { R32_PA_DIR &= ~PIN_PA_10_A0;}               /*PIN_PA0Ϊ*/
#define PIN_PRD_IN( )            { R32_PB_DIR &= ~PIN_PA_8_RD;}                /*PIN_RDΪ*/
#define PIN_PD_IN( )             { R32_PD_DIR &= ~(0xFFFF);}                   /*PIN_PDΪ*/
#define PIN_PD_OUT( )            { R32_PD_DIR |= 0xFFFF;}                      /*PIN_PDΪ*/

UINT8 buf[RECV_NUM];
UINT16 r,s;

/*******************************************************************************
* Function Name  : Delay_100ns
* Description    : ʱ(ʱΪ100MHZʱ,ʱȷ)
* Input          : int n;ʱʱ (n*100)ns
* Output         : None
* Return         : None
*******************************************************************************/
void Delay_100ns( int n )
{
    int i;
    
    while( n -- ) 
    {
        for( i = FREQ_SYS / 50000000; i != 0; -- i );
    }
}

/*******************************************************************************
* Function Name  : TIM0_INIT
* Description    : ʱ0ʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

void TIM0_INIT( void ) 
{
    R8_TMR0_CTRL_MOD =  0x00 ;                                                 /*ʱģʽ */
    R32_TMR0_COUNT = 0x0000000;                                                /*ʱǰֵ0*/
    R32_TMR0_CNT_END = 0x186A0;                                                /*ʱֵ10^5ʱ1ms */
    R8_TMR0_INTER_EN |= RB_TMR_IE_CYC_END;

    R8_INT_EN_IRQ_GLOB |= RB_IE_IRQ_GLOB;                                      /* ȫж */
    R8_TMR0_INT_FLAG = 0x7f;                                                   /* ж */
    R8_INT_EN_IRQ_0 |= RB_IE_IRQ_TMR0;                                         /* ʱж */
}

/*******************************************************************************
* Function Name  : IRQ_Handler
* Description    : IRQжϴ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
__irq void IRQ_Handler( void )
{
    if( R8_INT_FLAG_0 & RB_IF_TMR0 )                                           /* ʱж */
    {                                                                          /*һշ*/
        r = 0;
        s = 0;
    }
    TIM0_INIT( );
    printf("..");
}

/*******************************************************************************
* Function Name  : FIQ_Handler
* Description    : FIQжϴ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
__irq void FIQ_Handler( void )
{
    UINT8 i = 36;                                                              /*CH341ÿ32ֽڵݣȷȫ*/
    PIN_PD_IN( );                                                              /*PDΪ*/
    PIN_PWAIT_HIGH( );                                                         /*ֻʱãPD˿*/
    buf[r++] = R32_PD_PIN;                                                     /**/
    R8_TMR0_CTRL_MOD &= ~RB_TMR_COUNT_EN;                                      /*ضʱ*/

    while(i--)											                        
    {
        if(PIN_CH341MEM_WR == 0)                                               /*PIN_WRΪ͵ƽ*/
        {
            //Delay_100ns(1);                                                  /*ݵƬָѡʱʹWAITź*/
            PIN_PWAIT_LOW( );                                                  /*PIN_WAITCH341*/
            buf[r++] = R32_PD_PIN;                                             /*ȡ*/
            PIN_PWAIT_HIGH( );                                                 /*PIN_WAITCH341¸*/
            //Delay_100ns(1);
        }
        if(r >= SEND_NUM)                                                      /**/														
        {
            s = 0;
            r = 0;
        }
    }
    R32_INT_STATUS_PB   = 0xfffff;                                             /* жϱ־д1 */
    R32_TMR0_COUNT = 0x0000000;                                                /* ʱ㣬¼*/
    PIN_PD_OUT( );                                                             /*PIN_PDΪ*/
    R8_TMR0_CTRL_MOD |= RB_TMR_COUNT_EN;                                       /* ʱ*/
}

/*******************************************************************************
* Function Name  : mInitUART0
* Description    : Ϊprintfgetkeyʼ0
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

void mInitUART0( void )
{
    UINT32    x, x2;

    x = 10 * FREQ_SYS * 2 / 16 / 115200;                                        /* 115200bps */
    x2 = x % 10;
    x /= 10;
    if ( x2 >= 5 ) x ++;                                                        /*  */
    R8_UART0_LCR = 0x80;                                                        /* DLABλ1 */
    R8_UART0_DIV = 1;                                                           /* ԤƵ */
    R8_UART0_DLM = x>>8;
    R8_UART0_DLL = x&0xff;

    R8_UART0_LCR = RB_LCR_WORD_SZ ;                                             /* ֽڳΪ8 */
    R8_UART0_FCR = RB_FCR_FIFO_TRIG|RB_FCR_TX_FIFO_CLR|RB_FCR_RX_FIFO_CLR |    
                   RB_FCR_FIFO_EN ;                                             /* FIFOΪ14巢ͺͽFIFOFIFOʹ */
    R8_UART0_IER = RB_IER_TXD_EN;                                               /* TXD enable */
    R32_PB_SMT |= RXD0|TXD0;                                                    /* RXD0 schmitt input, TXD0 slow rate */
    R32_PB_PD &= ~ RXD0;                                                        /* disable pulldown for RXD0, keep pullup */
    R32_PB_DIR |= TXD0;                                                         /* TXD0 output enable */
}

/*******************************************************************************
* Function Name  : fputc
* Description    : ͨϢ
* Input          : c-- writes the character specified by c 
*                  *f--the output stream pointed to by *f
* Output         : None
* Return         : None
*******************************************************************************/

int fputc( int c, FILE *f )
{
    R8_UART0_THR = c;                                                           /*  */
    while( ( R8_UART0_LSR & RB_LSR_TX_FIFO_EMP ) == 0 );                        /* ȴݷ */
    return( c );
}

/*******************************************************************************
* Function Name  : FIQ_InitPB
* Description    : жóʼ 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

void FIQ_InitPB( void )
{
    R32_PB_PU  |= 0x00000001;                                                   /* GPIO Bã1ʾ */ 
    R32_PB_DIR &= ~0x00000001;                                                  /* GPIO BΪ , direction: 0=in, 1=out */

    R32_INT_ENABLE_PB |= 0x00000001;                                            /* GPIO Bλжʹ  1-ʹܣ0-ֹ */
    R32_INT_MODE_PB   |= 0x00000001;                                            /* GPIO BжϷʽ 1-ж,0-ƽж */      
    R32_INT_POLAR_PB  &= ~0x00000001;                                           /* GPIO Bжϼ 1-ж/ߵƽ0-½ж/͵ƽ */      
    
    R32_INT_STATUS_PB   = 0xfffff;                                              /* жϱ־д1 */
    R8_INT_EN_FIQ_1    |= RB_IE_FIQ_PB;                                         /* GPIO Bжʹ */ 
    R8_INT_EN_FIQ_GLOB |= RB_IE_FIQ_GLOB;                                       /* ȫжʹ */     
}

/*******************************************************************************
* Function Name  : MEM_recv
* Description    : MEMģʽ,RECV_NUM
* Input          : PUINT8 buf;ݻ
* Output         : None
* Return         : None
*******************************************************************************/
void MEM_recv(PUINT8 buf)
{
    UINT32 i = 0;
    while(1)
    {
        //if(PIN_CH341MEM_A0)                                                   /*PIN_A0Ϊߵƽ*/
        //{
        if(PIN_CH341MEM_WR == 0)                                                /*PIN_WRΪ͵ƽ*/
        {

            //Delay_100ns(1);                                                   /*ݵƬָѡʱʹWAITź*/
            PIN_PWAIT_LOW( );                                                   /*PIN_WAITCH341*/
            buf[i++] = R32_PD_PIN;                                              /*ȡ*/
            PIN_PWAIT_HIGH( );                                                  /*PIN_WAITCH341¸*/
        }
        if(i >= RECV_NUM)                                                       /*RECV_NUM*/														
        {
            break;
        }
      //}
    }	
}

/*******************************************************************************
* Function Name  : MEM_send
* Description    : CH563ڷݣMEMģʽ
* Input          : PUINT8 buf;ݻ
* Output         : None
* Return         : None
*******************************************************************************/
void MEM_send(PUINT8 buf)
{
    UINT32 i = 0;																				
    while(1)
    {	
        R32_PD_OUT = buf[i];                                                   /*ݿѡͨź֮ǰ׼*/
                                                                               /*Ϊ˱֤ȷЧƬٶȹ죬ж*/																		
        //if(PIN_CH341MEM_A0)                                                  /*PIN_A0Ϊߵƽ*/
        //{                                                                    /*CH341WRĬߵƽ*/
        if(PIN_CH341MEM_RD == 0)                                               /*PIN_RDΪ͵ƽ*/
        {																		
            //Delay_100ns(1);                                                  /*PIN_WAITCH563*/
            //PIN_PWAIT_LOW( );                                                /*ʱWAITźŽŸݵƬʵ*/
            //Delay_100ns(3);												
            i++;                                                               /*ͼ*/
            Delay_100ns(1);
            //PIN_PWAIT_HIGH( );                                               /*PIN_WAITCH563¸*/
        }
        if(i >= SEND_NUM)                                                      /*SEND_NUM*/														
        {
            break;
        }
        //}
    }
}

/*******************************************************************************
* Function Name  : main
* Description    : 
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/

int main( void ) 
{
    UINT8 recv_buf[RECV_NUM];                                                  /*ʾջ*/
    UINT8 send_buf[SEND_NUM];                                                  /*ʾͻ*/
    UINT32 i;                                                                  /*ռ*/
    UINT32 j;                                                                  /*ͼ*/

    Delay_ms( 100 );                                                           /*ʼ0*/
    mInitUART0( );                                                             /* Ϊüͨڼʾ */ 
    FIQ_InitPB( );                                                             /*жóʼ*/
    TIM0_INIT( ); 

    i = 0;
    r = 0;
    s = 0;
    PIN_PWR_IN( );                                                             /*PIN_WRΪ*/
    PIN_PRD_IN( );                                                             /*PIN_RDΪ*/
    PIN_PD_OUT( );                                                             /*PIN_PDΪ*/
    PIN_PWAIT_OUT( );                                                          /*PIN_WAITΪ*/
    PIN_PWAIT_HIGH( );                                                         /*ʼWAITߵƽ*/

    memset(recv_buf,0,RECV_NUM);                                               /*ʼջ*/
    for(j = 0;j <SEND_NUM;j++)                                                 /*ʼͻ*/
    {
        send_buf[j] = j%256;	
    }

    printf( "Ready to contact with 341MEM...\n" );
    while(1)
    {
        PIN_PD_OUT( );
        R32_PD_OUT = buf[s];
        if(PIN_CH341MEM_RD == 0)
        {
            s++;
            s = s%RECV_NUM;
            //Delay_100ns(1);
        }
    }

#if DEBUG
    printf( "Ready to receive 341MEM data...\n" );																		
    MEM_recv(recv_buf);/**/
    for(i=0;i<RECV_NUM;i++)                                                    /**/
    {
        printf("  %X",recv_buf[i]);
    }
#endif

#if DEBUG
    printf("\n");
    PIN_PD_OUT( );                                                             /* PIN_PDΪ */
    printf( "Ready to send data...\n" );                                         
    MEM_send(send_buf);                                                        /**/
#endif

    printf("MEM PARA model show over...\n"); 
}

/*********************************** endfile **********************************/
