#include "stdafx.h"

TEXINFO texInfo;
GLubyte texMem[4 * 1024 * 1024];

extern "C" __declspec(dllexport)
void grTexDownloadMipMap(GrChipID_t tmu,
                         FxU32 startAddress,
                         FxU32 evenOdd,
                         GrTexInfo  *info)
{
   GLuint textures[1];
   GLboolean residences[1];
   textures[0] = startAddress + 1;
   if(glAreTexturesResident(1, textures, residences)) glDeleteTextures(1, textures);

   /*switch(info->format)
	{
	case GR_TEXFMT_8BIT:
		MessageBox(NULL, "GR_TEXFMT_8BIT", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_YIQ_422:
		MessageBox(NULL, "GR_TEXFMT_YIQ_422", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_ALPHA_8:
		MessageBox(NULL, "GR_TEXFMT_ALPHA_8", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_INTENSITY_8:
		MessageBox(NULL, "GR_TEXFMT_INTENSITY_8", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_ALPHA_INTENSITY_44:
		MessageBox(NULL, "GR_TEXFMT_ALPHA_INTENSITY_44", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_P_8:
		MessageBox(NULL, "GR_TEXFMT_P_8", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_16BIT:
		MessageBox(NULL, "GR_TEXFMT_16BIT", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_AYIQ_8422:
		MessageBox(NULL, "GR_TEXFMT_AYIQ_8422", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_RGB_565:
		MessageBox(NULL, "GR_TEXFMT_RGB_565", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_ARGB_1555:
		//MessageBox(NULL, "GR_TEXFMT_ARGB_1555", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_ARGB_4444:
		//MessageBox(NULL, "GR_TEXFMT_ARGB_4444", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_ALPHA_INTENSITY_88:
		MessageBox(NULL, "GR_TEXFMT_ALPHA_INTENSITY_88", "Notice", MB_APPLMODAL);
		break;
	case GR_TEXFMT_AP_88:
		MessageBox(NULL, "GR_TEXFMT_AP_88", "Notice", MB_APPLMODAL);
		break;
	}*/

   int height = 1 << (8 - info->largeLod);
	int width = 1 << (8 - info->largeLod);

	switch(info->aspectRatio)
	{
		case GR_ASPECT_8x1:
			height >>= 3;
         break;
		case GR_ASPECT_4x1:
			height >>= 2;
			break;
		case GR_ASPECT_2x1:
			height >>= 1;
			break;
		case GR_ASPECT_1x1:
			break;
		case GR_ASPECT_1x2:
			width >>= 1;
			break;
		case GR_ASPECT_1x4:
			width >>= 2;
			break;
		case GR_ASPECT_1x8:
			width >>= 3;
			break;
	}
   
   if(!height) height = 1;
   if(!width) width = 1;
   
   TEXEL *texture = (TEXEL*)&texMem[startAddress << 1];
   GLubyte *tex = (GLubyte*)texture;
   GLushort *data = (GLushort*)info->data;

   int i, j;
   //int index = 0;

   switch(info->format)
   {
   case GR_TEXFMT_ARGB_1555:
      for(j = 0; j < height; j++)
      {
         for(i = 0; i < width; i++)
         {
            //texture[width * j + i].r = (GLubyte)(255.0f * ((data[width * j  + i] >> 10) & 31) / 31.0f);
            //texture[width * j + i].g = (GLubyte)(255.0f * ((data[width * j  + i] >>  5) & 31) / 31.0f);
            //texture[width * j + i].b = (GLubyte)(255.0f * ((data[width * j  + i]      ) & 31) / 31.0f);
            //texture[width * j + i].a = (GLubyte)(255.0f * ((data[width * j  + i] >> 15) &  1) /  1.0f);

            *tex++ = (GLubyte)((255.0f / 31.0f) * ((*data   >> 10) & 31));
            *tex++ = (GLubyte)((255.0f / 31.0f) * ((*data   >>  5) & 31));
            *tex++ = (GLubyte)((255.0f / 31.0f) * ((*data        ) & 31));
            *tex++ = (GLubyte)((255.0f        ) * ((*data++ >> 15)     ));
         }
      }
      break;

   case GR_TEXFMT_ARGB_4444:
      for(j = 0; j < height; j++)
      {
         for(i = 0; i < width; i++)
         {
            //texture[width * j + i].r = (GLubyte)(255.0f * ((data[width * j + i] >>   8) & 15) / 15.0f);
            //texture[width * j + i].g = (GLubyte)(255.0f * ((data[width * j + i] >>   4) & 15) / 15.0f);
            //texture[width * j + i].b = (GLubyte)(255.0f * ((data[width * j + i]       ) & 15) / 15.0f);
            //texture[width * j + i].a = (GLubyte)(255.0f * ((data[width * j + i] >>  12) & 15) / 15.0f);

            *tex++ = (GLubyte)((255.0f / 15.0f) * ((*data   >>   8) & 15));
            *tex++ = (GLubyte)((255.0f / 15.0f) * ((*data   >>   4) & 15));
            *tex++ = (GLubyte)((255.0f / 15.0f) * ((*data         ) & 15));
            *tex++ = (GLubyte)((255.0f / 15.0f) * ((*data++ >>  12)     ));
         }
      }
      break;
   }

   glBindTexture(GL_TEXTURE_2D, startAddress + 1); //binding 0 is reserved
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, texture);
  
   /*char string[256], d[256];

   strcpy(string, "startAddress = ");
   itoa(startAddress, d, 10);
   strcat(string, d);
   MessageBox(NULL, string, "mipmap", MB_APPLMODAL);
   return;


   strcpy(string, "width = ");
   itoa(width, d, 10);
   strcat(string, d);
   strcat(string, "\nheight = ");
   itoa(height, d, 10);
   strcat(string, d);
   strcat(string, "\nLOD = ");
   itoa(info->largeLod, d, 10);
   strcat(string, d);
   strcat(string, "\nAspect = ");
   itoa(info->aspectRatio, d, 10);
   strcat(string, d);

   strcat(string, " ");
   strcat(string, itoa(height, string, 10));
   strcat(string, " ");
   strcat(string, itoa(info->largeLod, string, 10));
   strcat(string, " ");
   strcat(string, itoa(info->aspectRatio, string, 10));
   strcat(string, " ");

   //MessageBox(NULL, string, "mipmap", MB_APPLMODAL);*/
}