Below are the steps required to flash a NextThingCo CHIP or PocketCHIP from the command line, as of November 2018. The web flasher no longer works, and there are numerous errors when flashing from the command line, mostly due to broken dependencies. The following method works for flashing a CHIP as of November 2018:

Note: Flashing must be done on Linux. Tested on Ubuntu and Rasparian. Mac OS seems to not work. 

1. Download and unpack the CHIP-SDK.zip from one of the following:
* https://archive.org/details/C.h.i.p.FlashCollection
* https://github.com/NextThingCo/CHIP-SDK
* https://github.com/Project-chip-crumbs/CHIP-SDK

2. Download and unpack CHIP-tools.zip from one of the following:
* https://archive.org/details/C.h.i.p.FlashCollection
* https://github.com/NextThingCo/CHIP-tools-backup
* https://github.com/Project-chip-crumbs/CHIP-tools

3. Move the CHIP-tools directory inside CHIP-SDK directory (CHIP-SDK/CHIP-tools). 

4. Download the a CHIP image from one of the following:
* https://archive.org/details/C.h.i.p.FlashCollection  (.zip contains all CHIP image variants)
* https://dl.bintray.com/yoursunny/CHIP/  (can download individual CHIP images)

Unzip it (if necessary) and move the desired image into the CHIP-SDK directory (CHIP-SDK/IMAGENAME). In my case since I'm flashing the Pocketchip I used the stable-pocketchip-b128 image. 

5. Navigate to the CHIP-SDK directory in terminal and run the build script: `./setup_ubuntu1404.sh` The build script should run. Multiple errors will be shown, including a fatal error when the script tries to get the CHIP-tools from a non-existant repo. This can be ignored since we already downloaded the CHIP-tools directory in step 2.

6. Put your CHIP in FEL mode by putting a jumper wire between GND and FEL. Connect the CHIP to your computer with USB (using the microUSB port on the CHIP, not the fullsize USB port).

7. Navigate to the CHIP-tools directory in terminal at CHIP-SDK/CHIP-tools and run the update firmware script. Use the -L option to explicitly specify the firmware versions from the flash-collection directory: `./chip-update-firmware.sh -L ../stable-pocketchip-b128`
