// Used for updating slider range for choosing CHIP Pros
function updateRangeValue (input) {
  var value = input.val();
  var maximum = 1000000; 
  var inputWidth = 285;

  var offLeft = Math.floor((value / maximum) * inputWidth - (((value / maximum) * inputWidth - inputWidth/2) / 100) * 24); 
  var offLeftAbs = value == maximum ? 215 : getOffsetLeftAbs(value.length, offLeft);
  // console.log('offleft', offLeft);
  // console.log('abs', offLeftAbs);
  // console.log('input pos left', input.position().left);

  input.next('output').css({'left': offLeftAbs +'px'});
  input.next('output').val(Number(value).toLocaleString());
}

function getOffsetLeftAbs(valLen, offLeft) {
  if (valLen === 6) {
    return offLeft - 24;
  }
  else if (valLen === 5) {
    return offLeft - 16;
  }
  else if (valLen === 4) {
    return offLeft - 11;
  }
  else {
    return offLeft;
  }
}

function updatePriceValue (input) {
  var value = input.val();
  var price = (value * 16).toLocaleString();
  $('#chippro_qty_price').html('<strong>$</strong> ' + price);
}

function validateForm () {
  var inputs = $('#chipProSaleInquiryPopup input');
  var textareas = $('#chipProSaleInquiryPopup textarea');

  for (var i = 0; i < textareas.length; i++) {
    if (!$(textareas[i]).val()) {
      return false;
    }
  }

  for (var i = 0; i < inputs.length; i++) {
    if (!$(inputs[i]).val()) {
      return false;
    }
  }

  return true;
}

function submitChipProSaleInquiry () {
  var chipProSaleInquiryForm = $('#chipProSaleInquiry');
  var chipProSaleInquiryBtn = $('#chipProSaleInquiryPopup .btn-primary.submit');

  if (validateForm()) {
    $('#chipProSaleInquiryPopup .alert-danger.validate').addClass('hidden');

    $.ajax('https://track.getchip.com/chippro', {
      'type': 'POST',
      'data': $('#chipProSaleInquiry').serialize() + '&devCycle=' + $('#devCycle').val(),
      'success': function () {
        chipProSaleInquiryForm.hide();
        $('#chipProSaleInquiryPopup .alert-success').removeClass('hidden');
        $('#chipProSaleInquiryPopup .modal-footer').addClass('hidden');
        $('#chipProSaleInquiryPopup .modal-footer.success').removeClass('hidden');
      },
      'error': function () {
        chipProSaleInquiryForm.hide();
        $('#chipProSaleInquiryPopup .alert-danger.error').removeClass('hidden');
        $('#chipProSaleInquiryPopup .modal-footer').addClass('hidden');
        $('#chipProSaleInquiryPopup .modal-footer.success').removeClass('hidden');
      }
    });
  }
  else {
    $('#chipProSaleInquiryPopup .alert-danger.validate').removeClass('hidden');
  }
}

$(document).ready(function() {
  $("#nav-toggle").click(function(e){
    e.preventDefault();
    $(this).toggleClass("current_page_item");
    $("header nav > .menu").slideToggle();
  });

  $('.tab_horizontal_section').easyResponsiveTabs({
    type: 'default', //Types: default, vertical, accordion
    width: 'auto', //auto or any width like 600px
    fit: true, // 100% fit in a container
    tabidentify: 'hor_1', // The tab groups identifier
    activate: function(event) { // Callback function if tab is switched
      var $tab = $(this);
      var $info = $('#nested-tabInfo');
      var $name = $('span', $info);
      $name.text($tab.text());
      $info.show();
    }
  });

  $('.tab_vertical_section').easyResponsiveTabs({
    type: 'vertical', //Types: default, vertical, accordion
    width: 'auto', //auto or any width like 600px
    fit: true, // 100% fit in a container
    closed: 'accordion', // Start closed if in accordion view
    tabidentify: 'hor_1', // The tab groups identifier
    activate: function(event) { // Callback function if tab is switched
      var $tab = $(this);
      var $info = $('#nested-tabInfo2');
      var $name = $('span', $info);
      $name.text($tab.text());
      $info.show();
    }
  });

  // Quantity slider
  var chipProQtyRange = $('#chippro_qty');
  updateRangeValue(chipProQtyRange);
  
  chipProQtyRange.on('input change', function () {
    var input = $(this);
    updateRangeValue(input);
    updatePriceValue(input);
  });

  // Sales inquiry form
  var chipProSaleInquiryBtn = $('#chipProSaleInquiryPopup .btn-primary.submit');
  chipProSaleInquiryBtn.on('click', submitChipProSaleInquiry);
});