/*
 *      piano.h -- Piano tuning program piano 
 *	by Guenther Montag 2003
 *
 *	derived from multimon
 *
 *      Copyright (C) 1996  
 *          Thomas Sailer (sailer@ife.ee.ethz.ch, hb9jnx@hb9w.che.eu)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* ---------------------------------------------------------------------- */

#ifndef _PIANO_H
#define _PIANO_H

/* ---------------------------------------------------------------------- */

//#define SAMPLE_RATE 22050
#define SAMPLE_RATE 44100
#define BLOCKLEN (SAMPLE_RATE/100)  /* 10ms blocks */
#define BLOCKNUM 4    /* must match numbers in multimon.h */
//#define PHINC(x) ((x)*0x10000/SAMPLE_RATE)
#define PHINC(x) (((x)*0x10000/SAMPLE_RATE*soundcorr))
#define COS(x) costabf[(((x)>>6)&0x3ffu)]
#define SIN(x) COS((x)+0xc000)
#define TONETABSIZE 106
#define FINETABSIZE 65
#define NUMDEMOD 2
#define SMALL_DEMOD &demod_piano, &demod_fine

/* ---------------------------------------------------------------------- */

struct demod_state {
	const struct demod_param *dem_par;
	union {
		struct l1_state_piano {
			unsigned int ph[TONETABSIZE];
			float energy[4];
			float tenergy[4][TONETABSIZE * 2];
			int blkcount;
			int lastch;
		} piano;
	
		struct l1_state_fine {
			unsigned int ph[FINETABSIZE];
			float energy[4];
			float tenergy[4][FINETABSIZE * 2];
			int blkcount;
			int lastch;
		} fine;
	} l1;
};

struct demod_param {
	const char *name;
	unsigned int samplerate;
	unsigned int overlap;
	void (*init)(struct demod_state *s);
	void (*demod)(struct demod_state *s, float *buffer, int length);
};

/* ---------------------------------------------------------------------- */

extern const struct demod_param demod_piano;
extern const struct demod_param demod_fine;
extern const float costabf[0x400];
extern const float tonetab[TONETABSIZE];
extern const struct demod_param *dem[NUMDEMOD];
extern struct demod_state dem_st[NUMDEMOD];
extern unsigned int dem_mask[NUMDEMOD];
extern int tone, chamberhzbias, freqinput, noteinput, autotune, verboselevel;
extern float bias, soundcorr, inputfreq;
extern int user_octave, admin_octave;
extern char note[32], foundnote[8], params[55];

/* ---------------------------------------------------------------------- */

void verbprintf(const char *fmt, ...);
int find_max_idx(const float *f, float noise, int tabsize);
void fine_init(struct demod_state *s);
void init_demod(void);
void user_octave_2_admin_octave(void);
void admin_octave_2_user_octave(void);


/* ---------------------------------------------------------------------- */
#endif /* _PIANO_H */
