/*
 *      mktonetab.c -- piano tone table generator
 * 	tone factory 
 * 	for development of
 * 	piano tuning program
 * 	free!
 *	by Gunther Montag 2003
 *	
 *	based on mkcostab.c 	
 *	
 *      Copyright (C) 1996  
 *          Thomas Sailer (sailer@ife.ee.ethz.ch, hb9jnx@hb9w.che.eu)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* ---------------------------------------------------------------------- */

#include <math.h>
#include <stdio.h>

/* ---------------------------------------------------------------------- */

#define TONETABSIZE 106

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	int chambertone = 440, i, octave = -4;
	FILE *ft;
	float expo, f;

	if (!(ft = fopen("tonetab.c", "w")))
		exit(1);
	fprintf(ft, "/*\n * This file is machine generated, DO NOT EDIT!\n */\n\n"
		"float tonetab[%i] = {", TONETABSIZE);
	for (i = 0; i < TONETABSIZE; i++) {
		if ((i & 3) == 0)
			fprintf(ft, "\n\t");
		if ((i % 12) == 0)
			octave++;
// the following starts with integer multiple of chambertone each octave
		f = 440.0 * pow (2, octave) * pow(2, ((i % 12) / 12.0)) ;
		fprintf(ft, "%-06.12f", f);
		if (i < TONETABSIZE-1) {
			fprintf(ft, ", ");
		}
	}
	fprintf(ft, "\n};\n");
	exit(0);
}
