
var viewer;


window.addEventListener("load", ComputedStyleViewer_initialize, false);

function ComputedStyleViewer_initialize()
{
  viewer = new ComputedStyleViewer();
  viewer.initialize(parent.FrameExchange.receiveData(window));
}


function ComputedStyleViewer()
{
  this.mObsMan = new ObserverManager(this);
  this.mURL = window.location;
  
  this.mTree = document.getElementById("olStyles");
  this.mOlBox = this.mTree.treeBoxObject;
}

ComputedStyleViewer.prototype = 
{
  
  mSubject: null,
  mPane: null,


  get uid() { return "computedStyle" },
  get pane() { return this.mPane },

  get subject() { return this.mSubject },
  set subject(aObject) 
  {
    this.mOlBox.view = new ComputedStyleView(aObject);
    this.mObsMan.dispatchEvent("subjectChange", { subject: aObject });
  },

  initialize: function(aPane)
  {
    this.mPane = aPane;
    aPane.notifyViewerReady(this);
  },

  destroy: function()
  {
    this.mOlBox.view = null;
  },

  isCommandEnabled: function(aCommand)
  {
    return false;
  },
  
  getCommand: function(aCommand)
  {
    return null;
  },


  addObserver: function(aEvent, aObserver) { this.mObsMan.addObserver(aEvent, aObserver); },
  removeObserver: function(aEvent, aObserver) { this.mObsMan.removeObserver(aEvent, aObserver); },


  onItemSelected: function()
  {
  }
};

function ComputedStyleView(aObject)
{
  var view = aObject.ownerDocument.defaultView;
  this.mStyleList = view.getComputedStyle(aObject, "");
  this.mRowCount = this.mStyleList.length;
}

ComputedStyleView.prototype = new inBaseTreeView();

ComputedStyleView.prototype.getCellText = 
function(aRow, aCol) 
{
  if (aCol.id == "olcStyleName") {
    return this.mStyleList.item(aRow);
  } else if (aCol.id == "olcStyleValue") {
    var prop = this.mStyleList.item(aRow);
    return this.mStyleList.getPropertyValue(prop);
  }
  
  return "";
}
