TITLE SWITCHC.ASM -- A.P.I. to Software Carousel -- November 21, 1990

PAGE	60,132

COMMENT ~
	This information is to help those writing their own software to take
	full advantage of the CAROUSEL environment.  The services Carousel
	provides are available by making a DOS call (INT 21) to service
	function 0DFh.

CAROUSEL adds an additional function call to DOS INT 21, function 0DFh.
This function is called through INT 21H as function DF hex (i.e. AH=0DFH).

If function DF is sent to DOS when CAROUSEL is NOT running,
then no function is performed and "AL" is returned zero by DOS.

If function DF is successful, "AL" returns with a 1.  If it is unsuccessful,
"AL" returns with 0FFh and AH contains an error code.

  ERROR RETURN TABLE (AH values)
	1	Invalid work area number was supplied
	2	Can't switch to a work area with no memory size
	3	Can't kill a program in a work area with nothing running
	4	Can't change the size of an active work area
	5	Invalid memory size was supplied
	6	Can't send a command to a work area with a command pending
	7	Software Carousel is busy with another 0DFh call; Try later
	8	Invalid register values supplied
	9	No memory block available
	10	Invalid memory block ID
	11	Invalid parameter block
	12	Error reading or writing a memory block
	13	Too many pending memory block requests
		AH=14 	The video screen can not be saved when the Carousel
			menu is up.


List of Software Carousel Programming Interface Services
--------------------------------------------------------

AL=0	Check if Carousel is resident in memory
	INPUT:	AL=0	DI='SL'	  DX='SL'

	OUTPUT:	AX=0FFh		Carousel is resident
		AX not 0FFh	Carousel not resident

AL=1	Switch to another WORK AREA
	INPUT:	AL=1	DI='SL'	  DX='SL'
		BL=WORK AREA NUMBER OR 0 TO TOGGLE TO NEXT AREA

	OUTPUT: Error returns are 1, 2 & 7 (see table)

AL=2	KILL the program in a WORK AREA
	INPUT:	AL=2	DI='SL'	  DX='SL'
		BL=WORK AREA NUMBER

	OUTPUT: Error returns are 1, 3 & 7 (see table)

AL=3	GET WORK AREA size and PROGRAM STATUS
	INPUT:	AL=3	DI='SL'	DX='SL'
		BL=WORK AREA NUMBER

	OUTPUT: DX=SIZE OF WORK AREA in Kilobytes
		BL=0	NO PROGRAM IS RUNNING
		BL=1	A PROGRAM IS RUNNING
		Error returns are 1 & 7 (see table)

AL=4	GET A WORK AREA NAME
	INPUT:	AL=4	DI='SL'	  DX='SL'
		BL=WORK AREA NUMBER

	OUTPUT: ES:BX POINT TO NAME OF WORK AREA UNLESS IT IS THE DEFAULT NAME
		CX=NUMBER OF CHARACTERS IN WORK AREA NAME
		CX=0 IF IT IS THE DEFAULT WORK AREA NAME
		Error returns are 1 & 7 (see table)

AL=5	CHANGE THE SIZE OF A WORK AREA
	INPUT:	AL=5	DI='SL'
		BL=WORK AREA NUMBER
		DX=NEW SIZE IN KILOBYTES

	OUTPUT: BX=MINIMUM SIZE ALLOWED
		CX=MAXIMUM SIZE AVAILABLE
		Error returns are 1, 4, 5 & 7

AL=6	CHANGE A WORK AREA NAME
	INPUT:	AL=6	DI='SL'	  DX='SL'
		BL=WORK AREA NUMBER
		DS:SI POINT TO NEW NAME
		CX=NUMBER OF CHARACTERS IN NEW NAME (CX=0 MEANS TO USE DEFAULT)
			(MAXIMUM VALUE IS 24 decimal)

		Error returns are 1 & 7 (see table)

AL=7	SEND A COMMAND TO A WORK AREA (CAN BE USED TO START A PROGRAM IN
				ANOTHER MEMORY WORK AREA)
	INPUT:	AL=7	DI='SL'	  DX='SL'
		BL=WORK AREA NUMBER
		CX=NUMBER OF CHARACTERS IN COMMAND (127 decimal is maximum)
		DS:SI POINT TO COMMAND LINE

	OUTPUT: Error returns are 1, 6 & 7 (see table)

AL=8	ENABLE OR DISABLE SWITCHING TO ANOTHER WORK AREA or the CAROUSEL MENU
		The user will be unable to switch to another work area or
		call the Carousel Menu.

	INPUT:	AL=8	DI='SL'	  DX='SL'
		BL=0  DISABLE KEYBOARD;	BL=1  ENABLE KEYBOARD
		BL=2 Disable ALL switching until the automatic startup is done.
			Note: When BL=2 is used, it even disables switching
				thru the API (ie. AX=DF01h).
		BL=3 Status. Find out if keyboard is disabled or enabled.

	OUTPUT: BL=0 if keyboard switching is disabled.
		BL=1 if keyboard switching is enabled.
		BL=2 if all switching disabled until automatic startup is done.

AL=9	BOOT THE SYSTEM
	INPUT:	AL=9	DI='SL'	  DX='SL'
		BL = 0 Ask user if she is sure she wants to boot.
		BL = 1 Don't ask user if she is sure.

	OUTPUT: NONE

AL=10	GET MEMORY SIZE AND WORK AREA NUMBER OF CURRENT WORK AREA

	INPUT:	AL=10	DI='SL'	  DX='SL'

	OUTPUT: BL=WORK AREA NUMBER
		DX=MEMORY SIZE IN KILOBYTES

		error return is 7 if in the middle of a work area switch

AL=11	TELL CAROUSEL THE INTERRUPT TO ISSUE OR THE FAR CALL TO MAKE WHEN A 
	SWITCH IS COMPLETED.
	
	INPUT:	AL=11	DI='SL'	  
		BH=INTERRUPT NUMBER OR 0
		IF BH=0, THEN DS:DX IS THE ADDRESS OF THE FAR CALL

		BL=FUNCTION NUMBER WITHIN INTERRUPT.  THIS FUNCTION IS ISSUED
				BY CAROUSEL AFTER EACH WORK AREA SWITCH.  THE
				NEW WORK AREA NUMBER WILL BE IN THE BL REGISTER
				WHEN CAROUSEL ISSUES THIS FUNCTION.
		
		CL=FUNCTION NUMBER WITHIN INTERRUPT.  THIS FUNCTION IS ISSUED
				BY CAROUSEL WHEN IT IS OK FOR A RESIDENT 
				PROGRAM TO DO DOS FUNCTION CALLS.  FOR
				INSTANCE, IT MAY OPEN A DISK FILE AND
				DISPLAY A HELP MENU ON THE SCREEN.  THIS
				FUNCTION WILL NOT BE ISSUED BY CAROUSEL UNTIL
				AFTER THE PROGRAM HAS ISSUED DOS CALL 0DFH
				WITH A 12 IN THE AL REGISTER.

	OUTPUT:	NONE

NOTE:	CAROUSEL WILL ISSUE THIS INTERRUPT (OR MAKE THE FAR CALL) AFTER EACH 
	SWITCH.  THE NEW WORK AREA NUMBER WILL BE IN THE BL REGISTER WHEN CAROUSEL
	ISSUES THIS INTERRUPT (OR FAR CALL).

AL=12	TELL CAROUSEL THAT A PROGRAM NEEDS TO KNOW WHEN IT IS OK TO PERFORM 
	DOS CALLS.

	INPUT:	AL=12	DI='SL'	  DX='SL'

	OUTPUT:	NONE

AL=13	SELECTIVELY ENABLE OR DISABLE CAROUSEL MENU & SWITCHING TO ANOTHER WORK AREA
	NOTE: THIS FUNCTION IS DIFFERENT FROM 8 ABOVE BECAUSE IT DISABLES ALL
		SWITCHING INCLUDING SWITCHING USING FUNCTION 0DF01H. 
		FUNCTION 8 ABOVE DISABLES SWITCHING FROM THE KEYBOARD ONLY.
		ALSO, THIS FUNCTION TAKES EFFECT IMMEDIATELY, EVEN IF THERE IS
		A PENDING SWITCH REQUEST.		

	NOTE: Software Carousel keeps track of how many times switching has
		been disabled and enabled with this function.  So that if it
		has been disabled 2 times in a row without being re-enabled
		in between, then it will not be re-enabled until the call to
		enable it has been done twice.

	INPUT:	AL=13	DI='SL'	  DX='SL'
		BL=0 TO DISABLE SWITCHING;	BL=1 TO ENABLE SWITCHING

	OUTPUT: NONE

AL=14	QUIT out of Software Carousel.  That is, take Software Carousel out of
	memory.

	INPUT:	AL=14	DI='SL'	  DX='SL'
		BL=0 Ask user if she is sure she wants to quit.
		BL=1 Don't ask user if she is sure.

	OUTPUT:	NONE

AL=15	TELL CAROUSEL THE INTERRUPT TO ISSUE OR THE FAR CALL TO MAKE BEFORE
	SWITCHING OUT OF A WORK AREA AND WHEN RETURNING TO A WORK AREA.
	Software Carousel will also issue the FAR CALL with AH=0ffh, when
	Software Carousel is about to terminate and take itself out of memory.
	
	INPUT:	AL=15	DI='SL'
		BH=INTERRUPT NUMBER OR 0
		IF BH=0, THEN DS:DX IS THE ADDRESS OF THE FAR CALL

		BL=FUNCTION NUMBER WITHIN INTERRUPT.  This will be the value in
				the AH register when the interrupt or far call 
				is issued by Carousel before switching out of a
				work area. (BL=0f0h thru 0ffh are not valid.)
		
		CL=FUNCTION NUMBER WITHIN INTERRUPT.  This will be the value in
				the AH register when the interrupt or far call
				is issued by Carousel at the completion of a 
				switch to a new work area.  (CL=0f0h thru 0ffh
				are not valid.)
	 	
		CH=0 to make Carousel issue the call for every switch.
		CH=1 to make Carousel issue the call only if switching from or 
			to the current work area.
		CH=80h to make Carousel STOP issuing the call for every switch.
		CH=81h to make Carousel STOP issuing the call for the current 
			work area. (unchain)

	OUTPUT:	Error return 8.

	- When Carousel issues this call before a switch the following values
	  will be in the registers:

	  INPUT: All registers saved on the stack.
		AH=value from BL register above.
		BH=current work area number.
		BL=1-12 for the work area number that we are switching to.
		   14=going to menu; 15=going to boot; 20=quit out of Carousel;
		   21=quit out of Carousel without asking user if she is sure.

	OUTPUT: AL=0 tells Carousel to do the switch now.
		AL=1 tells Carousel NOT to do the switch yet.
		AL=2 tells Carousel NOT to do the switch at all.

	- When Carousel issues this call after a switch is complete the
	  following values will be in the registers:

	  INPUT: All registers saved on the stack.
		AH=value from CL register above.
		BH=new work area number.
		BL=new work area number.
		DL=1 if the new work area has been killed since the last time
			it was the active work area.

	OUTPUT: none

	- When Carousel issues this call when it is about to terminate, the 
	  following values will be in the registers.

	  INPUT: All registers saved.
		AH=0ffh

	  OUTPUT: none

AL=16	Get the version number of Software Carousel.

	INPUT:	AL=16	DI='SL'	  DX='SL'

	OUTPUT:	BX=version number. (ex. 301h for version 3.01)
		CX bit values:
		  bit 0 on = Carousel is running in Extended Memory
		  bit 1 on = Carousel is running in Expanded Memory
		  bit 2 on = Carousel is storing code in Expanded Mem
		  bit 3 on = Carousel is storing code in Extended Mem
		  bit 4 on = Carousel is storing code on disk.

		ES:DX points to Software Carousel table of special keys.
		  The table ends with a byte equal to 0FFh.
		  The table consists of entries of 3 bytes each.
		  The 3rd byte in each entry is an internal flag.

		  The 3 bytes per entry are as follows:
		  ------------------------------------------
		1st byte		2nd byte	3rd byte
		--------		--------	--------
		work area 1 key		hot key		1
		work area 2 key		hot key		2
		work area 3 key		hot key		3
		work area 4 key		hot key		4
		work area 5 key		hot key		5
		work area 6 key		hot key		6
		work area 7 key		hot key		7
		work area 8 key		hot key		8
		work area 9 key		hot key		9
		work area 10 key	hot key		10
		work area 11 key	hot key		11
		work area 12 key	hot key		12
		toggle key		hot key		13
		toggle key		hot key		13
		menu key		hot key		14
		hercules page 0 key	hot key		16
		hercules page 1 key	hot key		17
		hercules text mode key	hot key		18
		ALT key (83)		DEL key(56)	15
		0FFh (end of table marker)


AL=17	Make Software Carousel save or restore the video screen image.
	Only 1 screen image can be saved at a time.

	INPUT:	AL=17  DI='SL'  DX='SL'  BL=0

		BH=0 to make Carousel save the screen, clear the screen and 
			then put it into 80 X 25 text mode.
		BH=1 to restore the screen.
		BH=2 to get status (find out if there is a screen saved away)
		BH=3 to make Carousel save the screen but NOT clear it or 
			change the mode.  This API can only be used for screen
			modes 0 thru 7 and 11h. 
		
		CL=0 (WAIT) Make Software Carousel not return from this call
			until the screen is saved or restored.
		CL=1 (NO WAIT) Make Software Carousel return from this call
			immediately.
		CL=2 used internally by Carousel.

	OUTPUT: BH=0 if there is NOT a screen saved away.
		BH=1 if there is a screen saved away.

		error returns are 7, 8, 9 and 14

	NOTE: The WAIT (CL=0) version of this call should never be made from
		 a hardware interrupt monitor loaded before Software Carousel.

AL=18	Get and change the Software Carousel flags for displaying dashes when
	switching work areas and for informing Software Carousel that Novell
	Netware is running.

	INPUT:	AL=18  DI='SL'	  DX='SL'
		if getting flags
			BL=0
		if setting flags
		  	BL=1 
			CL=0 to display dashes
			CL=1 to NOT display dashes
			CH=0 if Novell Netware NOT running
			CH=1 if Novell Netware is running

	OUTPUT:
		CL=0 if dashes will display on work area switches
		CL=1 if dashes will NOT display
		CH=0 or 1 (Novell flag value).  NOTE: Software Carousel does
			not make an attempt to determine if Novell Netware is
			running.

AL=19	Invoke the Carousel menu or change the time allowed for starting 
	programs during the automatic program start up of Software Carousel.

	INPUT:	AL=19  DI='SL'	  DX='SL'

	To change start up time
	-----------------------
		BL = 0
		BH = number of seconds (1 - 99)

	To invoke menu
	--------------
		BL = 14

	OUTPUT: none
		error return is 8 (see table)

AL=20	Get the address of Software Carousel's interrupt 21h handler and the
	segment address of the Software Carousel stub that is always running
	in conventional (low) RAM.

	INPUT:	AL=20	DI='SL'	  DX='SL'
		BX=0

	OUTPUT:	ES:BX points to the interrupt 21h handler
		DS is equal to the low RAM Carousel segment

		error return is 8 (see table)

AL=21	Access the pool of 16k blocks of memory maintained by Carousel.
	The block may be in lower (conventional) RAM, Extended RAM,
	Expanded RAM, or on a disk.

	- Get (request) a 16K block of memory from Software Carousel
		INPUT:  AL=21  DI='SL'  DX='SL'
			CL=0

		OUTPUT: CH= memory block ID
			error returns are 8 or 9 (see table)

	- Release (free) a 16k block of memory.  That is, return the block to
	  the Software Carousel memory pool.
		INPUT:  AL=21  DI='SL'  DX='SL'
			CL=1
			CH=memory block ID

		OUTPUT: none
			error returns are 8 or 10 (see table)

	- Read to (receive data) or write to (send data) a memory block.
		INPUT:  AL=21  DI='SL'  DX='SL'
			CL=2
			ES:BX = segment:offset of a parameter block

		OUTPUT: none
			error returns are 1, 8, 10, 11, 12 & 13 (see table)

		The parameter block format is as follows:
			Field			Field
		Offset  Size	Type		Description
		------  -----	----		--------------------------
		00	1	byte (DB)	Command type (receive/send)
		01	1	byte (DB)	Completion Code
		02	1	byte (DB)	Memory Block ID
		03	1	byte (DB)	Work Area number
		04-07	4	double word(DD)	Pointer to data buffer
		08-09	2	word (DW)	Length of buffer in bytes
		10-11	2	word (DW)	Memory block offset
		12-15	4	double word(DD)	Pointer to post routine

		Explanation of fields:
		----------------------
		- Command Type
			0 = Read from memory block (i.e. fetch data)
			1 = Write to memory block (i.e. store data)

		- Completion code
			0FFh	Command has been accepted and is in the queue
				for processing.
			0	Command completed successfully

			Anything other than 0 or 0FFh is an error code.
			Error codes are the following:

			 1   =	   Invalid work area number in parameter block.
			10 (0Ah) = Invalid memory block ID
			11 (0Bh) = Invalid information in parameter block
			12 (0Ch) = Hardware error accessing the memory block

		- Memory Block ID
			This field must contain a memory block ID obtained from
			the "Get Memory Block" call (i.e. AL=21,CL=0).  If this
			field is invalid, an error code of 10 will be returned
			in the "completion code" field of the parameter block.

		- Work Area number
			This field must contain the work area number of the
			work area that the data buffer is in.  If the data
			buffer is contained in a TSR program that is loaded
			before Carousel, then this field should contain
			a zero.  The valid values for this field are 0 thru 12.

		- Pointer to Data Buffer
			This is the address (segment:offset) of the buffer
			that contains the data to be written (when writing)
			or the buffer where the data from the memory block
			is to be read to (when reading).

		- Length of buffer in bytes
			This field contains the number of bytes to be read to
			or written from the buffer.  Your program must ensure
			that the buffer is large enough.
			This field must be in the range of 2 to 16,384 bytes,
			and it must be an even number.

		- Memory block offset
			This field contains a number in the range of 0 to
			16,384.  This is the offset within the 16K memory block
			that the data is to be read from or written to.

		- Pointer to post routine
			If this field is NOT zero, it is an indication to
			Software Carousel that your program has a post routine
			(a code paragraph) for Software Carousel to call
			when the read or write to the memory block is complete.
			Software Carousel will make a far call to this routine
			upon completion of the read or write.
			Your program returns control by issuing a far return.
			When the post routine is called, the AL register
			contains the completion code and the ES:BX register
			will be pointing to the parameter block.

			If this field is zero, no post routine will be called
			and the application program will have to check
			the command completion field to determine when the
			command has completed.

AL=22	Interrupt driven print buffer interface.

	INPUT:	AL=22	DI='SL'	  DX='SL' and (DS:SI if BL=8 or 10)

		BL=0 to get the status of interrupt driven print interface.
		BL=1 to temporarily DISABLE (stop) interrupt driven print and
			resume normal BIOS printing.
		BL=2 to ENABLE (restart) using interrupt driven print and stop
			using the BIOS printing routines.
		BL=3 to PAUSE outputting characters to the printer.  The
			characters will continue to be placed in the buffers.
		BL=4 to RESUME outputting characters to the printer.
		BL=5 to have the print buffer flushed (emptied)
		BL=6 to delete one memory block from print buffer.  BH must be
			equal to the memory block ID.  CX must be equal to 0.
		BL=7 to set or get the number of copies currently being used
			for input to the print buffer.	CX must be equal to new
			number of copies wanted; or CX must be equal to 0FFFFh
			to get the number of copies currently being used; or CX
			must be equal to -99 to make Carousel start a new print
			job set.
		BL=8 to get number of 16K print buffer blocks and number of
			bytes in the buffer.  DS:SI must point to a string of
			at least 50 words (100 bytes).

		BL=9 to stabilize the print buffer.  That is, the data in the
			RAM buffers is moved into 16K blocks.

		BL=10  to change the table of print buffer ID's maintained by
			Software Carousel.  DS:SI must point to the new table.

	OUTPUT:	If BL = 0 thru 5 on input, then CL equals the status:

		bit 0 :
			off - Carousel was started without interrupt driven
				print.  This cannot be changed without quitting
				out of Carousel and restarting.
			on  - Carousel was started with interrupt driven print.
		bit 1 :
			off - Interrupt driven print is temporarily disabled.
			on  - Interrupt driven print is enabled.
		bit 2 :
			off - Printing is temporarily paused.
			on  - Printing is NOT paused.

		CH = 0 if the print buffer is empty.
		CH = 1 if there is something in the print buffer.
		------------------------------------------------------------

		If BL = 7 on input, then on output CX is equal to the number
			of copies being used for printed input.

		If BL = 8 on input, then the following values are returned:
			BL = number of 16k blocks of print buffer
			DX:CX = number of bytes in the print buffer
			BH = ID of the current (or next) memory block being
				printed.
			The string pointed to by DS:SI is filled in with the
			memory block ID numbers and work area numbers of the
			P'N'R print routine.  The low byte of each of the 50
			words in the table is the memory block ID (0FFh
			indicates an empty entry).  The high byte of each word
			in the table is the work area number of the work area
			that was active when the data was put into the print
			buffer.  The high bit of the work area number may be
			on.  That high bit is toggled to indicate that there
			has been a change in the number of copies to print.

			Note: ID = 0FFh means there is no block.

		If BL = 9, then the table described above is replaced by the
			table pointed to by DS:SI.

		error return is 8 (see table)


AL=23	Alarm clock and chime processing.

	INPUT:	AL=23	DI='SL'	 DX='SL'

		To cancel or start chimes
		-------------------------
			BL=0
			 and
			BH=0 to disable chimes
			BH=1 to chime on the hour
			BH=2 to chime on the 1/2 hour
			BH=4 to chime on the 1/4 hour
			BH=0FFh to get the current chime status

		To add an alarm
		-------------------------
			BL=1
			BH=type of alarm
			DS:SI pointing to 3 byte hour/minute/second
			seconds = 0FFh if don't care about seconds accuracy.

		To delete an alarm
		-------------------------
			BL=2
			DS:SI pointing to 3 byte hour/minute/second
			seconds = 0FFh if no seconds were specified

		To change an alarm or chime tone
		--------------------------------
			BL=3 to change alarm tone
			BL=4 to change hourly chime tone
			BL=5 to change 1/2 hour chime tone
			BL=6 to change 1/4 hour chime tone
			CX=Number of times to repeat tones
			BH=Number of frequencies in table. (Max. is 20)
			DS:SI pointing to table of frequencies.
				The table consists of sets of 1 byte & 1 word.
				The byte is the # of ticks per tone; the word
				is the frequency value.


	OUTPUT:
		If BL = 0 on input, then
			CL=0 if no chime set
			CL=1 if hourly chime set
			CL=2 if 1/2 hourly chime set
			CL=4 if 1/4 hour set

		If BL = 1 or 2 on input, then CX=number of alarms
		currently set.

		error return is 8 (see table)

AL=24	Switch to another work area and do NOT return back to the application
	program issuing this call, until the user has switched back to the
	work area that issued this call.

	INPUT:	AL=24	DI='SL'	  DX='SL'
		BL=Work Area number or 0 to toggle to next work area.

	OUTPUT: If NO error then BL=last work area number.
		Error returns are 1, 2 & 7 (see table)

AL=25	Software Carousel memory storage specifications.

	INPUT:  AL=25  DI='SL'  DX='SL'
		ES:BX point to storage area

		CL=0 to obtain general storage pool information
		CL=1 to obtain current status of individual work area storage

	OUTPUT: If CL=0 on input, then the memory area pointed to by ES:DI will
		be filled in with the following information:

		Definition			Size		Offset
		-----------------------		----		----------
		Total Storage			word		00-01
		Total Free Storage		word		02-03
		Total Lower RAM			word		04-05
		Free Lower RAM			word		06-07
		Total Expanded RAM		word		08-09
		Free Expanded RAM		word		0A-0B
		Total Extended RAM		word		0C-0D
		Free Extended RAM		word		0E-0F
		Total Disk Space		word		10-11
		Free Disk Space			word		12-13
		----------------------------------------------------------

		If CL=1 on input, then the memory area pointed to by ES:DI will
		be filled in with the following information:

		Definition			Size		Offset
		-----------------------		----		---------------
		Work Area  1 Memory		word		00-01
		Work Area  1 Display		word		02-03
		Work Area  2 Memory		word		04-05
		Work Area  2 Display		word		06-07
		Work Area  3 Memory		word		08-09
		Work Area  3 Display		word		0A-0B
		Work Area  4 Memory		word		0C-0D
		Work Area  4 Display		word		0E-0F
		Work Area  5 Memory		word		10-11
		Work Area  5 Display		word		12-13
		Work Area  6 Memory		word		14-15
		Work Area  6 Display		word		16-17
		Work Area  7 Memory		word		18-19
		Work Area  7 Display		word		1A-1B
		Work Area  8 Memory		word		1C-1D
		Work Area  8 Display		word		1E-1F
		Work Area  9 Memory		word		20-21
		Work Area  9 Display		word		22-23
		Work Area 10 Memory		word		24-25
		Work Area 10 Display		word		26-27
		Work Area 11 Memory		word		28-29
		Work Area 11 Display		word		2A-2B
		Work Area 12 Memory		word		2C-2D
		Work Area 12 Display		word		2E-2F
		Print'N'Run Storage in use	word		30-31
		Other Storage in Use		word		32-33
		Carousel Overhead Storage 	word		34-35

		NOTE: All fields above contain storage amounts in 1K bytes


----------------------------
TSR Programming Information:
----------------------------
	If a Terminate & Stay Resident program loaded before Software
	Carousel needs to know when Software Carousel has started and when
	it is about to QUIT the following method can be used.

	The TSR program should hook itself to the interrupt 21h chain
	and watch for the following interrupt 21h calls that Software
	Carousel will make:

	When Software Carousel starts it will:
	-----------------------------------------------------------
		issue an interrupt 21h with
			AX = DF00h
			DS:SI pointing to "CAROUSEL"

	When Software Carousel is about to QUIT it will:
	-----------------------------------------------------------------
		issue an interrupt 21h with AX = E804h

		If it is Software Carousel version 4.00 or higher, the
		DX is equal to 'SL'.


THE FOLLOWING IS A PROGRAM THAT SWITCHES TO ANOTHER WORK AREA.

PROGRAM OPTIONS:

SWITCHC/x	x IS A WORK AREA NUMBER FROM 1-12; SWITCH TO WORK AREA x
SWITCHC		TOGGLE TO THE NEXT SEQUENTIAL WORK AREA

~

NAME	SWITCHC


CODE    SEGMENT

ASSUME	CS:CODE,DS:CODE

	ORG	100H

START:
	MOV	SI,80H	  ;AT PSP+80H
	CLD
	LODSB		;GET THE COUNT BYTE
	XOR	AH,AH
	MOV	CX,AX		;NUMBER OF CHARACTERS TO TEST
	MOV	BL,0
	JCXZ	CHANGE		;NO OPTION IS TOGGLE TO NEXT WORK AREA
	DEC	CX
	INC	SI
	LODSB			;GET NEXT OPTION BYTE
	SUB	AL,30H		;MAKE IT 1-9
	MOV	BL,AL
	DEC	CX
	JCXZ	CHANGE		;ONE OPTION ONLY, DO IT
	CMP	AL,1
	JNZ	ERR_DONE	;INVALID PARAMETER, FIRST VALUE MUST BE A '1'
	LODSB
	SUB	AL,30H		;MAKE IT 0-9
	MOV	BL,10		;START AT 10
	ADD	BL,AL		;AND ADD THE SECOND DIGIT
	CMP	BL,12		;DID IT EXCEED 12?
	JA	ERR_DONE	;IT DID
CHANGE:
	MOV	AX,0DF01H	;CHANGE WORK AREAS FUNCTION
	MOV	DI,'SL'
	MOV	DX,DI
	INT	21H		;CALL CAROUSEL
	DEC	AL		;WAS IT SUCCESSFULL?
	JZ	OK_DONE		;IT WAS
	MOV	AL,AH		;GIVE USER REAL ERROR CODE
	JMP	SHORT OK_DONE
ERR_DONE:
	MOV	AL,1		;RETURN ERRORLEVEL=1
OK_DONE:
	MOV	AH,4CH
	INT	21H		;TERMINATE
	JMP	$

CODE    ENDS
	END	START


;If you are having problems, or would like further assistance:
;	CALL ;CALL 603-497-5636 9:00 - 17:00 EST.
;	      After June 1, 1996 call (945) 581-3330 
;
;	or write
;			SunShine Software Company, Inc.
;			Attn: Technical Support
;			6950 Cypress Road
;			Plantation, FL	33317
