;	Static Name Aliases
;
	TITLE   setime.c
	.8087
_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	_BSS, _DATA
	ASSUME DS: DGROUP, SS: DGROUP

_DATA      SEGMENT

TaskMonName	db	'$TASKMON', 0	;; Null Terminated String
ImeName		db	'LXIME   '	;; Should be 8 bytes String
TaskMon		dd	?		;; LXJEX API Entry
ImeApi		dd	?		;; LXIME API Entry

_DATA      ENDS

_TEXT      SEGMENT
	ASSUME	CS: _TEXT

	PUBLIC	_SetIme

_SetIme	PROC NEAR

	mov	dx, offset TaskMonName	;; ds:dx points Device Name
	mov	ax, 3d00h		;; Open '$TASKMON' Device
	int	21h
	jc	Error

	mov	bx, ax			;; File Handle
	mov	dx, offset TaskMon	;; Far Ptr Buffer
	mov	cx, 4			;; 4 bytes
	mov	ax, 4402h		;; Read I/O Control Data
	int	21h
	jc	Error

	mov	ah, 3eh			;;File Close
	int	21h
;
; Get Call-Back Handle from LXIME
;
	mov	si, offset ImeName	;; ds:si points App Name
	mov	ax, 0202h		;; Get Call-Back Hanlde
	call	dword ptr TaskMon	;; Call LXJEX API
	or	ax, ax
	jnz	Error
; If got successfully, Call-Back Handle is in BX
;
; Get API address of LXIME (BX: Call-Back Handle of LXIME)
;
	mov	ax, 0301h		;; Get User API Address
	call	dword ptr TaskMon	;; Call LXJEX API

	mov	word ptr ImeApi, di
	mov	word ptr ImeApi + 2, es
; If es:di equals 0000h:0000h, API is not registered.
	mov	ax,es
	or	ax,di
	jz	Error
;
; LXIME Function mode settings
;	BX: bit 0	0:Graphic Cursor not monitored, 1: monitored
;	    bit 1	0:Via Int 16h, 1:Via ClipBoard
;	    bit 2`15	Reserved (ALL 0)

	mov	ax, 0101h		;; Set function mode
	mov	bx, 0002h		;; Via ClipBoard
	call	dword ptr ImeApi	;; Call LXIME API
; Flag is destroyed. CY=1 signals an error.
	jc	Error
	xor	ax,ax
	ret

Error:	mov	ax,0ffffh
	ret	

_SetIme	ENDP

_TEXT	ENDS
	END
