#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mem.h>
#include <conio.h>

#include "wattcp.h"

FILE * DebugIn  = NULL;
FILE * DebugOut = NULL;

longword resolve( char *name )
{
    if( !name ) return 0L;
    return (123456789L);
}

void sock_init(void )
{
  tcp_config(NULL);
}

int tcp_tick( sock_type *s )
{
  return 1;
}

int tcp_open( tcp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler )
{
    memset( s, 0, sizeof( tcp_Socket));
    s->ip_type = TCP_PROTO;
    s->myaddr = my_ip_addr;
    s->myport = lport;

    if (!DebugIn) {
      DebugIn  = fopen("debug.in", "r");
    }

    if (!DebugOut) {
      DebugOut = fopen("debug.out", "w");
    }

    return( 1 );
}

int tcp_listen( tcp_Socket *s, word lport, longword ina, word port, dataHandler_t datahandler, word timeout )
{
    if (DebugIn) {
      return -1;
    }

    memset( s, 0, sizeof( tcp_Socket));
    s->ip_type = TCP_PROTO;
    s->myaddr = my_ip_addr;
    s->myport = lport;
    s->hisport = port;
    s->hisaddr = ina;

    if (!DebugIn) {
      DebugIn  = fopen("debug.in", "r");
    }

    if (!DebugOut) {
      DebugOut = fopen("debug.out", "w");
    }

    return( 1 );
}

int sock_puts( sock_type *s, byte *dp )
{
    int len;

    len = strlen((char *)dp);

    if (s->tcp.sock_mode & TCP_MODE_ASCII) {
        if (len) fprintf(DebugOut,(char *)dp);
        fprintf(DebugOut, "\r\n" );
    } else {
        fprintf(DebugOut, (char *)dp);
    }
    return(len);
}

int sock_write( sock_type *s, byte *dp, int len )
{
    return fwrite((char *)dp, 1, len, DebugOut);
}

int sock_fastwrite( sock_type *s, byte *dp, int len )
{
    return fwrite((char *)dp, 1, len, DebugOut);
}

int sock_gets( sock_type *s, byte *dp, int n )
{
    if (!fgets((char *)dp, n, DebugIn)) return -1;
    /* Rip off the trailing newline */
    dp[strlen((char *)dp)-1] = 0;
    return strlen((char *)dp);
}

int sock_fastread( sock_type *s, byte *dp, int len )
{
    return fread((char *)dp, 1, len, DebugIn);
}

void sock_close( sock_type *s )
{
}

int _ip_delay0( sock_type *s, int timeoutseconds, sockfunct_t fn, int *statusptr )
{
  int status = 0;

  kbhit();
  if (statusptr) *statusptr = status;
  return( status );
}

int _ip_delay1( sock_type *s, int timeoutseconds, sockfunct_t fn, int *statusptr)
{
  int status = 0;

  kbhit();

  if (fn) {
    status = fn(s);
  }
  if (statusptr) *statusptr = status;
  return( status );
}

int _ip_delay2( sock_type *s, int timeoutseconds, sockfunct_t fn, int *statusptr)
{
  int status = 0;

  kbhit(); /* permit ^c */
  if (fn) {
    status = fn(s);
  }
  if (statusptr) *statusptr = status;
  return( status );
}

int sock_dataready( sock_type *s )
{
  if (DebugIn) {
    return !feof(DebugIn);
  }
  return 0;
}

int sock_established( sock_type *s )
{
  if (DebugIn) {
    return !feof(DebugIn);
  }
  return 0;
}

void sock_sturdy( sock_type *s, int level )
{
}

int sock_tbleft( sock_type *s )
{
  return 1024;
}

/* End of wattcpdb.c */
