/* $Id: lookovr.c 1.10 2000/04/11 04:18:13 rwhitby Exp $ */
/* $Source: A:/SRC/TCP/NCSATCP/SRC/RCS/lookovr.c $ */

/*
 * Portions developed by the Educational Resources Center, Clarkson University.
 * Portions developed by the National Center for Supercomputing Applications,
 * University of Illinois at Urbana-Champaign.
 */

#include <alloc.h>
#include <ctype.h>
#include <dos.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "signal.h"
#include "fcntl.h"
#include "nkeys.h"
#include "telnet.h"
#include "protocol.h"
#include "data.h"
#include "windat.h"
#include "hostform.h"
#include "newwin.h"
#include "vsdata.h"
#include "mem.h"
#include "newkeys.h"

/* #define	DEBUGMEM	1 */

#define HTELNET 23

/* #define CONSOLE_VERBOSE 1 */

extern struct config Scon;

extern int kbcodes;
extern unsigned n_chkchar();
unsigned int newkey();
extern int slip_mode;
extern struct twin *creatwindow(),*newin;

extern struct	twin	*addsess();
extern int     numberoflines;             /* the default number of lines */
extern	char	*env_config;
extern unsigned char	start_color;
extern int stand,
	basetype,
	ftpact,					/* ftp transfer is active */
	rcpact,					/* rcp transfer is active */
	viewmode,					/* What are we looking at? */
	transok,					/* is file transfer enabled? */
	vton,
	capon,					/* overall capture on or not */
	foundbreak,				/* trap Ctrl-C */
	machparm;
#define SSIZE   64
extern	unsigned int	rawbuff_size;
extern unsigned char s[SSIZE+2],parsedat[12],
		colors[NCOLORS],		/* base colors */
		myipnum[4], *blankline;
extern int	seenlines;		/* set if user requested lines ... */

int breakstop(),errhandle();
extern long time(),n_clicks(),lastt;
extern long	lastftp_time;
extern struct config def;				/* Default settings obtained from host file */
extern struct machinfo *mp;		/* Pointer to a machine information structure */

#define PSDUMP 128


#ifdef  FTPPW
extern unsigned long ftppassword;      /* used to store onboard random password */
#endif
#ifdef	SCRIPT
extern void *Script_Spawn();
#endif

/************************************************************************/
/* vhead
*  place the header for new sessions in.
*/
vhead(v)
	int v;
{
	vprint(v,"LXTELNET " VERSION " - HP200LX TCP/IP Development Kit ");
	vprint(v,"<http://lxtcp.hplx.net/>\r\n");
	vprint(v,"\nAlt-H presents a summary of special keys.\r\n");
}

/*********************************************************************/
/* endall
*  clean up and leave
*/
endall()
	{
	netshut();
#ifdef	SCRIPT
	Script_CloseAll();
#endif
	n_cur(NUMLINES+1,0);			/* go to bottom of screen */
	n_color(start_color);
/*	n_borcol(0); */
	n_clear();
	n_draw(blankline,cols);  	/* blank it out */
	n_cur(NUMLINES,0);
#ifdef	MEM_DEBUG
	mem_check();
	mem_term();
#endif
	exit(0);				/* return to DOS */

}

/*********************************************************************/
/*  errhandle
*   write error messages to the console window
*/
errhandle()
	{
	char *errmsg;
	int i,j;

	while (ERR1 == Sgetevent(ERRCLASS,&i,&j)) {
		errmsg = neterrstring(j);
		VSwrite(console->vs,errmsg,strlen(errmsg));
		VSwrite(console->vs,"\r\n",2);
	}

}


/*********************************************************************/
/*  vprint
*   print to a virtual screen
*/
vprint(w,s)
	int w;
	char *s;
	{

	VSwrite(w,s,strlen(s));
}

/*********************************************************************/

helpmsg() {
	int i;

	i = n_color(current->colors[0]); 

	n_clear();
	n_cur(0,0);
	nprintf(SCREEN,"Keyboard usage: \n\n");
	nprintf(SCREEN,"ALT-A     add a session                    ALT-Y     Interrupt Process\n");
	nprintf(SCREEN,"ALT-N     next session                     ALT-O     Abort Output\n");
	nprintf(SCREEN,"ALT-M     message screen                   ALT-Q     Are you there?\n");
	nprintf(SCREEN,"ALT-E     escape to DOS shell              ALT-U     Erase line\n");
	nprintf(SCREEN,"ALT-H     this help screen                 ALT-K     Erase Kharacter\n");
	nprintf(SCREEN,"ALT-C     toggle capture on/off            ALT-W     send internal ftp passwd\n");
	nprintf(SCREEN,"ALT-R     reset VT102 screen               ALT-X     close connection\n");
	nprintf(SCREEN,"ALT-P     change a screen parameter        ALT-L     last (previous) session\n");
        nprintf(SCREEN,"ALT-D     Dump Screen to Capture file      ALT-MINUS Script Spawn/Kill\n");
	nprintf(SCREEN,"ALT-T     start file transfer as if typed: ftp [internet address]\n");
	nprintf(SCREEN,"ALT-I     send my internet address to host ALT-V     Rshell to host\n");
	nprintf(SCREEN,"ALT-S     skip scrolling, jump ahead       ALT-Z     Rlogin to host\n");
	nprintf(SCREEN,"ScrLock   pause/restart screen (DO NOT use Ctrl-NumLock)\n");
	nprintf(SCREEN,"ScrLock   enter/exit scroll-back mode\n");
	nprintf(SCREEN,"\nALT-F3    abort program completely.  STRONGLY discouraged\n");

	nprintf(SCREEN,"\n\nPress ESC for information page, space bar to return to session:\n");
        nprintf(SCREEN,"\n       Or Press <RETURN> for program status information\n");
	n_color(i);
}

help2(c) 
	int c;
	{
	int i;

	i = n_color(current->colors[0]); 

	n_clear();
	n_cur(0,0);

	nprintf(SCREEN,"Please retain the following notices:\n\n");
	nprintf(SCREEN,"     Portions developed by the Educational Resources Center,\n");
	nprintf(SCREEN,"     Clarkson University, Potsdam, New York.\n");
	nprintf(SCREEN,"     Portions developed by the National Center for Supercomputing Applications,\n");
	nprintf(SCREEN,"     University of Illinois, Urbana-Champaign.\n");
	nprintf(SCREEN,"\nPress space bar to return to session\n");

	n_color(i);
}

/*********************************************************************/

#define	IGNORE	(WILL+4)

printoption(mode, option, result)
        char    *mode;
        int     option;
        int     result;

{
static  char *results[]={"WILL","WONT","DO","DONT","IGNORE"};

#ifdef CONSOLE_VERBOSE
        nprintf(CONSOLE,"%s Option %s (%s)\n",mode, option < NTELOPTS ? telopts[option] : "Unknown Option",results[result-WILL]);
#endif

}

int
checkoption(option)
        int     option;         /* return > -1 if option is valid */
{

        if(option > -1)  {
                if(option > NTELOPTS)
                        option = -1;
        }
        return(option);
}

sendoption(tw, option, result)
        struct twin *tw;
        int     option;
        int     result;
{
        char buff[6];

	 if(result == IGNORE)
		return;
        sprintf(buff,"%c%c%c",IAC,result, option);
        netwrite(tw->pnum, buff, 3);
}

send_type(tw)
        struct twin *tw;

{
  char buff[64];
  static  char *mode_type="VT102";
  sprintf(buff,"%c%c%c%c%s%c%c",IAC,SB,TELOPT_TTYPE,TELQUAL_IS,
	  mode_type,IAC,SE);
  /* listen to this!
     type VT102 is not in the assigned numbers RFC, the closest
     recognized terminal  is DEC-VT100  however, nobody has
     DEC-VT100 in their termcap! What a waste to have assigned
     numbers but not use them!
  */
  
  netwrite(tw->pnum, buff, strlen(mode_type) + 6);
#ifdef CONSOLE_VERBOSE
  nprintf(CONSOLE,"IAC SB Sent type %s\n",mode_type);
#endif
}

tnsuboption(tw, suboption,subsize)  /* handle sub option negotiation */
        struct twin *tw;
        unsigned char *suboption;
        int     subsize;
{

        switch (*suboption) {

           case TELOPT_TTYPE :
                if(*(suboption+1) == TELQUAL_SEND) {
                        send_type(tw);
                }
		if(!(tw->flags & TWIN_FLAGS_SENTANY_TYPE)) {
		  tw->flags |= TWIN_FLAGS_SENTANY_TYPE;
		  sendoption(tw,TELOPT_NAWS,WILL);        /* tell them we are willing to naws */
		}
                break;

          default:
                break;
       }

}

dooption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((checkoption(option)) > -1) {
                result = WILL;
		 if(tw->myopts[option]) {
			printoption("DO",option,IGNORE);
			return;
		 }
                tw->myopts[option] = 1;
                switch (option) {
                        case TELOPT_EOR :
                                break;
                        case TELOPT_BINARY :
				 if(!(tw->flags & TWIN_FLAGS_NOBINARY)) {
	                               tw->binary = 1;
			         }
			  	 else {
					result = WONT;
					tw->binary = 0;
					tw->myopts[option] = 0;
				 }
                                break;
                        case TELOPT_TTYPE:
                                break;
                        case TELOPT_SGA :  /* supress go ahead */
                                tw->igoahead = 1;
                                break;
                        case TELOPT_TM :
                                break;
                        case TELOPT_NAWS :              /* do naws */
                                break;
			case TELOPT_ECHO :		/* won't echo when told to */
                        default:
                                result = WONT;
                                tw->myopts[option] = 0;
                                break;
                }
                printoption("DO",option,result);
                sendoption(tw, option, result);
#ifdef	DONTDOTYPE
                if(option == TELOPT_SGA) {
                         sendoption(tw,TELOPT_TTYPE,WILL);
                }
#endif
                if(option == TELOPT_NAWS) {
                        unsigned char wbuff[80];

                        sprintf(wbuff,"%c%c%c%c%c%c%c%c%c",
                                IAC,SB,TELOPT_NAWS,0,cols,0,NUMLINES+1,IAC,SE);
                        netwrite(tw->pnum,wbuff,9);
#ifdef CONSOLE_VERBOSE
                        nprintf(CONSOLE,"IAC SB NAWS %d %d \n",cols,NUMLINES+1);
#endif
                }
        }
 	 else {
		printoption("DO",option,WONT);
		sendoption(tw,option,WONT);
	 }
}

wontoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {
                result = DONT;
                tw->hisopts[option] = 0;
                switch (option) {
                        case TELOPT_ECHO:
                                tw->echo = 0;
                                break;

                        case TELOPT_SGA :  /* supress go ahead */
                                tw->igoahead = 0;
                                break;

                        case TELOPT_TM :
				 tw->flags &= ~TWIN_FLAGS_DISCARDING;
		                 printoption("WONT",option,IGNORE);
                                return;

                        default:
                                break;
                }
                printoption("WONT",option,result);
                sendoption(tw, option, result);
        }
}


willoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((option = checkoption(option)) > -1) {

                result = DONT;
                switch (option) {

                        case TELOPT_ECHO :  
			   	result = DO;    
                                tw->echo = 1;
                                tw->hisopts[option]++;
			 case TELOPT_EOR :
                                tw->hisopts[option]++;
                                result = DO;
                                break;
                        case TELOPT_BINARY :
                                result = DO;
                                tw->hisopts[option]++;
                                break;
                        case TELOPT_SGA :
                                tw->hisopts[option]++;
                                result = DO;
                                break;
                        case TELOPT_TM :
				 tw->flags &= ~TWIN_FLAGS_DISCARDING;
		                 printoption("WILL",option,IGNORE);
				 return;
                        case TELOPT_NAWS:       /* server will do naws, has no meaning */
                        default:
                                result = DONT;
                }
	  	 if((tw->hisopts[option] > 2) && result == DO)
			result = IGNORE;	/* loop detect */
                printoption("WILL",option,result);
                sendoption(tw, option, result);
        }
}

dontoption(tw, option)
        struct twin *tw;
        int option;
{
        int result;

        if((checkoption(option)) > -1) {
                tw->myopts[option] = 0;
                result = WONT;
		if(option == TELOPT_ECHO) {
		   	result = IGNORE;
		}
                printoption("DONT",option,result);
		if(result != IGNORE)
	                sendoption(tw, option, result);
        }
 	 else {
		printoption("DONT",option,WONT);
		sendoption(tw,option,WONT);
	 }  
}




screendump(t1)                  /* dump the current screen */
        struct twin *t1;
{
   int  x,len;
   unsigned char *c,*d;
   struct VSline  *l;

   if(t1->capfp) {
         if(VSvalids(t1->vs))
                return;
         capstat("Screen Dump");

	  l = VSIw->vistop;
         for(x=0; x < NUMLINES+1; x++) {
/*                c = &VSIw->linest[x]->text[0]; */
		 c = l->text;
                d = c + VSIw->allwidth;  /* allwidth = 79 for an 80 width window */
                while((*d == ' ' || *d == 0) && d > c)    /* don't print trailing blanks */
                        d--;
                len = d - c + 1;
                fprintf(t1->capfp,"%*.*s\r\n",len,len,c);
		 l = l->next;
         }
         fprintf(t1->capfp,"\f");
         statline();
   }

}

/***************************************************************************/
/*  dosescape
*  escape to dos for processing
*  put the connections to automated sleep while in DOS
*/
dosescape()
	{
	int i;
	char	*com;
	n_clear();
	n_cur(0,0);
	if (ftpact || rcpact) {
		nprintf(SCREEN,"Please wait until file transfer is finished\n");
		nprintf(SCREEN,"\nPress any key to continue\n");
		return(0);
	}
	nprintf(SCREEN,"Warning, some programs will interfere with network communication and can\n");
	nprintf(SCREEN,"cause lost connections.  Do not run any network programs from this DOS shell.\n");
	nprintf(SCREEN,"Type 'EXIT' to return to CUTCP/CUTE\n");

/*
*  invoke a put-to-sleep routine which calls netsleep every 8/18ths of a sec
*  Also:  disable ftp,rcp when asleep and suppress error messages
*/
#ifdef	BADWAY

	i = system("command");		/* call DOS */
#else
	com = getenv("COMSPEC");
     	if(!com) {
	   	nprintf(SCREEN,"COMSPEC variable not found, can not escape to DOS\n");
		i = -1;
	}
     	else 
	   	i = spawnl(P_WAIT,com,com,NULL);
#endif
	if (i < 0) {
		nprintf(SCREEN,"\n\nError loading COMMAND.COM\n");
		nprintf(SCREEN,"Make sure COMMAND.COM is specified under COMSPEC.\n");
		nprintf(SCREEN,"It must also be in a directory which is in your PATH statement.\n");
	}

	n_row();
	nprintf(SCREEN,"\nPress any key to return to telnet\n");
	return(0);
}

/***********************************************************************/
/*  creatwindow
*   returns a pointer to a new window
*/
struct twin *creatwindow()
	{
	struct twin *p;
	int i;
        /* char errbuf[90]; */

	p = (struct twin *)mem_calloc(sizeof(struct twin),1);
	if (!p)
		return(NULL);
#ifdef	SCRIPT
	p->Script = NULL;
#endif
	p->pnum = -1;
	p->telstate = 0;
	if (vton)
		p->termstate = basetype;
	else
		p->termstate = DUMBTYPE;
	p->linemode[0] = 0;
	p->flags = 0L;
	p->echo = 0;
	p->next = NULL;
	p->prev = NULL;
	p->sstat = '*';				/* connection not opened yet */

	if (mp == NULL) {
		p->bksp = 127;
		p->del = 8;
		p->halfdup = 0;

		for (i=0; i<3; i++)					/* start default colors */
			p->colors[i] = colors[i];

		i = VSnewscreen(0,0,cols,0,p);			/* create a new virtual screen */
	}
	else {
		if(mp->keymap) 
			p->key_map = Key_Load_File(mp->keymap);
	        p->flags = mp->flags;

		p->bksp = mp->bksp;
		if (p->bksp == 127)
			p->del = 8;
		else
			p->del = 127;
	        if(p->halfdup = mp->halfdup)
                        p->echo = 0;
		if(mp->vtmargin == 0xff)
		       	p->flags |= TWIN_FLAGS_MARGIN_BELL;

		for (i=0; i<3; i++)					/* start default colors */
			p->colors[i] = colors[i];

		i = VSnewscreen(mp->bkscroll,1,cols,0,p);	/* create a new virtual screen */

		if (i >= 0 && (mp->vtwrap == 1))
			VSwrite(i,"\033[?7h",5);		/* turn wrap on */
		VSscrolcontrol(i,-1,mp->clearsave);	/* set clearsave flag */
	}

	if (i < 0) {
                nprintf(SCREEN,"VSnewscreen returned %d\n",i);
		 return(NULL);
        }
	p->vs = i;
	screens[i] = p;						/* we need to know where it is */

	return(p);
}

/***********************************************************************/

/***********************************************************************/
/*  inswindow
*	insert a window into the circular linked list
*
*   current is used as a reference point for the new entry, the new entry
*   is put next in line past "current"
*/
inswindow(t,wtype)
	struct twin *t;
	int wtype;
	{
	struct twin *p,*q;

/*
*   put it into the port number array
*/
	if (wtype)
		wins[t->pnum] = t;

/*
*  check for the NULL case for current.
*/
	if (current == NULL || current == console) {
		current = t; 
		statline();
		return(0);
	}

	p = current;					/* find surrounding elements */
	if (p->prev == NULL) {			/* only one now, we are adding 2nd */
		t->next = p;
		t->prev = p;
		p->next = t;
		p->prev = t;
	}
	else {							/* adding third or more */
		q = p->next;				/* find next one */

		t->prev = p;
		t->next = q;				/* insert it as next after current */
		q->prev = t;
		p->next = t;
	}

}

/***********************************************************************/
/*  delwindow()
*   take a window out of the linked list
*/
delwindow(t,wtype)
	struct twin *t;
	int wtype;
	{
	struct twin *p,*q;
	if(t->key_map)
	       	Key_Free_Lib(t->key_map);
#ifdef	SCRIPT
	if(t->Script)
	       	Script_Event(SCRIPT_CLOSE,t->Script,0);
#endif
	if (wtype)	
		wins[t->pnum] = NULL;		/* take out of array */

	p = t->prev;
	q = t->next;

	if (p == NULL) {				/* is only node */
		freewin(t);
		current = console;
		return(0);
	}

	if (p == q) {				/* two in list */
		p->next = NULL;
		p->prev = NULL;
	}
	else {
		q->prev = p;
		p->next = q;			/* merge two links */
	}

	freewin(t);					/* release the space */			

	return(0);
}

/************************************************************************/
/*  freewin
*   deallocate and detach all associated memory from a window
*/
freewin(t)
	struct twin *t;
	{

	VSdetatch(t->vs);
	mem_free(t);
	return(0);

}

/************************************************************************/
/*
*  hexbyte
*   return a byte taken from a string which contains hex digits
*/
hexbyte(st)
	char *st;
	{
	int i;

	if (*st >= 'A')
		i = ((*st|32)-87)<<4;
	else
		i = (*st-48)<<4;

	st++;

	if (*st > 'A')
		i |= (*st | 32)-87;
	else
		i += (*st-48);

	return(i);

}

/***********************************************************************/
/*  menu support
*   New 5/22/88 - TK
*   Provide menus with a reasonable user interface for the user to
*   select colors or other parameters.
*
*   This menu system provides two types of entries.
*   1. Up to nine static choices, 0-8.  Each static choice is encoded
*      into the data structure and automatically rotated by the user.
*      The user cannot select an illegal value.
*   2. A string choice.  A maximum string length is honored.
*   There must be at least 20 characters open for each field, longer
*   if the field is longer.  Static choices cannot be longer than 20 chars.
*
*/

/*
*  structure for the menu entries
*/
struct pt {
	int posx,posy,		/* row and col position on screen for field */
		choice,			/* which is the currently visible selection */
		replen;			/* length of reply if a string is allowed to be entered */
	char *vals[18];		/* pointers to the actual choices */
};

#define LO 5
struct pt pc[] = {
	/* session colors */
	{LO+0,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},
	{LO+1,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},

	{LO+2,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},
	{LO+3,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},

	{LO+4,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},
	{LO+5,44,0,0,"black","blue","green","cyan","red","magenta","yellow","white","BLACK","BLUE",
                        "GREEN","CYAN","RED","MAGENTA","YELLOW","WHITE",NULL},

	/* things which also apply to this session */
	{LO+6,44,0,0,"Local echo","Remote echo",NULL},
	{LO+7,44,1,0,"Backspace","Delete",NULL},
	{LO+8,44,0,20,NULL,"                     ",NULL},
	{LO+9,44,0,0,"VT102","Dumb TTY","Throughput Measurement",NULL},
       {LO+10,44,0,0,"Off","On"},
	/* things which apply over all of telnet */
	{LO+12,44,0,35,NULL,"                                      ",NULL},
	{LO+14,44,0,0,"Disabled","Enabled",NULL},
	{LO+0,0}
};

/************************************************************************/
/* menuit
*  draw the current line at the required position.
*  If the field length (replen) is longer than 20 chars, fill in the
*  entire field width.  All fields are padded with spaces to their
*  length when printed, but stored without padding.
*/
menuit(p,n)
	struct pt p[];
	int n;
	{
	int i;
	char fmt[12];

	n_cur(p[n].posx,p[n].posy);
	if ((i = p[n].replen) < 20) 			/* i = larger of replen and 20 */
		i = 20;

	sprintf(fmt,"%%-%d.%ds\n",i,i);				/* create format string */
	nprintf(SCREEN,fmt,p[n].vals[p[n].choice]);		/* put out value */
}

/************************************************************************/
/*  makechoice
*   Allow the user to travel between choices on the screen, selecting
*   from a list of legal options.
*   Arrow keys change the selections on the screen.  The data structure
*   must be set up before entering this procedure.
*/
int
makechoice(p,maxp,spec)
	struct pt p[];
	int maxp,spec;
	{
	int i,oldln,ln,c;
	
	oldln = ln = 0;
	n_color(7);

	for (i=1; i<maxp; i++) 		/* print the opening selections */
		menuit(p,i);

/*
*  For each keystroke, repaint the current line and travel around the
*  data structure until the exit key is hit.
*/
	do {
		if (oldln != ln) {
			n_color(7);					/* re-write old line in normal color */
			menuit(p,oldln);
		}
		n_color(0x70);
		menuit(p,ln);					/* write the current line in reverse */
		if (spec)
			makespecial();				/* display special requirements */
		n_cur(p[ln].posx,p[ln].posy);	/* reset cursor to current entry */
		oldln = ln;

		c = nbgetch();
		switch (c & ~0x1000) {					/* act on user's key */
		case CURUP:
			if (ln)
				ln--;
			else
				ln = maxp-1;
			break;
		case CURDN:						/* up and down change current field */
			if (++ln >= maxp)
				ln = 0;
			break;
		case PGUP:
		case HOME:
			ln = 0;
			break;
		case PGDN:
		case ENDKEY:
			ln = maxp-1;
			break;
		case 32:				/* space, tab and arrows change field contents */
		case 9:
		case CURRT:
			i = ++p[ln].choice;		/* if blank or non-existant, reset to 0 */

			if (!p[ln].vals[i] || !(*p[ln].vals[i]) || ' ' == *p[ln].vals[i])
				p[ln].choice = 0;
			break;
		case CURLF:
			if (p[ln].choice)
				p[ln].choice--;
			else {				/* if at zero, search for highest valid value */
				i = 0;
				while (p[ln].vals[i] && *p[ln].vals[i] && ' ' != *p[ln].vals[i])
					i++;
				if (i)
					p[ln].choice = i-1;
			}
			break;
		case 8:
		case 21:
		case 13:
				/* BS, Ctrl-U, or return */
/*
*  if allowed, the user can enter a string value.
*  prepare the field, by printing in a different color to set it apart.
*/
			if (p[ln].replen) {
				p[ln].choice = 1;
				n_color(0x1e); /* was 1 */	/* underline color */
				n_cur(p[ln].posx,p[ln].posy);
				for (i=0; i<p[ln].replen; i++)  /* blank out field */
					n_putchar(' '); 
				n_cur(p[ln].posx,p[ln].posy);
				nbgets(p[ln].vals[1],p[ln].replen);
			}
			break;
		default:
			break;
		}

	} while (c != F1 && c != F10 && c != 27);

	return((c == F1) || (c == F10));

}

/************************************************************************/
/*  makespecial
*  Apart from standard menuing, we want to show an example of what the
*  text is going to look like in each of the three attributes.
*/
makespecial()
	{
	n_cur(LO-1,15);
	n_color(pc[0].choice + (pc[1].choice <<4));
	nprintf(SCREEN,"normal\n");
	n_cur(LO-1,25);
	n_color(pc[2].choice + (pc[3].choice <<4));
	nprintf(SCREEN,"reverse\n");
	n_cur(LO-1,35);
	n_color(pc[4].choice + (pc[5].choice <<4));
	nprintf(SCREEN,"underline\n");

}
#define STNORM	0
#define GOAHEAD 249
#define WILLTEL 251
#define WONTTEL 252
#define DOTEL	253
#define DONTTEL 254
#define IACFOUND 6

#define SUBSIZE 32


/************************************************************************/
/*  parmchange
*   ALT-P from the user calls this routine to prompt the user for
*   telnet parameter values.
*   Set up the menuing system with the current values for this session.
*   Call the menuing routines, then analyze the results when it returns.
*
*   Affects the settings of:
*   session color, name, local echo, backspace/del, terminal type
*   overall file transfer enable, capture file name, screen access method
*
*/
parmchange()
	{
	int i,colsave;

static char *setup_buf[]={
	"ALT-P  Parameter menu \n",
	"<Select parameters, F1 to accept, ESC to leave unchanged>\n\n",

	" Color setup and session parameters \n",
	" Text:\n",
	
	"          Normal Foreground (nfcolor) -\n",
	"          Normal Background (nbcolor) -\n",
	"         Reverse Foreground (rfcolor) -\n",
	"         Reverse Background (rbcolor) -\n",
	"       Underline Foreground (ufcolor) -\n",
	"       Underline Background (ubcolor) -\n",
	"        Use remote echo or local echo -\n",
	"                  Backspace key sends -\n",
	"                         Session name *>\n",
	"                        Terminal type -\n",
	"                           Wrap Lines -\n",
	" Parameters which apply to all sessions \n",
	"                    Capture file name *>\n",
	"                     File transfer is - \n",
	""
};
/*
*  set up the screen for the menus
*  Positions of text interlock with fields of menu routines
*/
	colsave = n_color(7);
	n_clear();
	n_cur(0,0);

	for(i=0;strlen(setup_buf[i]);i++)
	       	nprintf(SCREEN,setup_buf[i]);

nprintf(SCREEN,"\n\nUse arrow keys to select, Enter clears changeable field (*>)\n");

/*
*  set values for menus from our telnet-stored values
*/
	i = current->colors[0];		/* session colors */
	pc[0].choice = i & 15;
	pc[1].choice = i >> 4;
	i = current->colors[2];
	pc[2].choice = i & 15;
	pc[3].choice = i >> 4;
	i = current->colors[1];
	pc[4].choice = i & 15;
	pc[5].choice = i >> 4;
	pc[6].choice = current->echo;
	if (current->bksp == 8)		/* backspace setting */
		pc[7].choice = 0;
	else
		pc[7].choice = 1;
	pc[8].vals[0] = current->mname;		/* session name */
	
	pc[9].choice = current->termstate - 1;	/* terminal type */
	pc[10].choice = VSIw->DECAWM;
	pc[11].vals[0] = def.capture;		/* capture file name */
	pc[12].choice = Scon.ftp;			/* filetransfer enable */


	if (makechoice(&pc,13,1)) {			/* call it and check the results */
/*
*  Work on results, only if user pressed 'F1', if ESC, this is skipped.
*
*
*  check for new capture file name
*/
		VSIw->DECAWM = pc[10].choice;
		if (pc[11].choice) {
			strcpy(s,pc[11].vals[1]);
			if (s[0] && s[0] != ' ') {	/* no NULL names */
				Snewcap(s);
				Sgetconfig(&def);
			}
			*pc[11].vals[1] = 0;
			pc[11].choice = 0;
		}
/*
*  check whether to enable or disable file transfers
*/
		if (pc[12].choice != Scon.ftp) {
			Scon.ftp = pc[12].choice;
			Sftpmode(Scon.ftp);
		}
		if (pc[12].choice != Scon.rcp) {
			Scon.rcp = pc[12].choice;
			Srcpmode(Scon.rcp);
		}
/*
*  check remote or local echo mode
*/
		if (pc[6].choice != current->echo && current->telstate < RLOGIN) {
			if (current->echo = pc[6].choice) {		/* assign = is on purpose */
				sprintf(s,"%c%c%c",255,DOTEL,1);	/* telnet negotiation */
				netpush(current->pnum);
				netwrite(current->pnum,s,3);
			}
			else {
				sprintf(s,"%c%c%c",255,DONTTEL,1);
				netpush(current->pnum);
				netwrite(current->pnum,s,3);
			}
		}
/*
*  check function of backspace or delete
*/
		if (pc[7].choice) {
			current->bksp = 127;		/* backspace/delete are swapped */
			current->del = 8;
		}
		else {
			current->bksp = 8;			/* are normal */
			current->del = 127;
		}
/*
*  check new session name
*/
		if (pc[8].choice) {
			strcpy(s,pc[8].vals[1]);
			if (s[0] != ' ' && s[0]) {		/* limit of 14 chars stored */
				strncpy(current->mname,s,15);
				current->mname[14] = 0;
			}
			*pc[8].vals[1] = 0;
			pc[8].choice = 0;
		}
/*
*  check terminal type
*/
		if (pc[9].choice != current->termstate-1)  /* ### bug fix, was pc[6] */
			current->termstate = pc[9].choice + 1;
		if (current->termstate == LOADTYPE) {
		   	LoadInit(current);
		}
/*
*  assign new colors
*/
		i = pc[0].choice + (pc[1].choice <<4);   /* normal color */
		if (i != current->colors[0]) {
			current->colors[0] = i;
			RSsetatt(127,current->vs);		/* seed the current screen */
			n_color(current->colors[0]);	/* seed ncolor */
                        if(!VSvalids(current->vs))
                                VSIw->attrib = current->colors[0];
		}
		current->colors[1] = pc[4].choice + (pc[5].choice <<4);
		current->colors[2] = pc[2].choice + (pc[3].choice <<4);
	}


/*
*  go back to telnet
*/
	n_color(colsave);
	wrest(current);

}

#ifdef	SCRIPT
Spawn_Script(struct twin *t)
{
	char	sname[80];
	int	i;

	wrest(console);
	nprintf(CONSOLE,"\nEnter Script File Name: ");
	sname[0] = 0;
	while (0 >= (i = RSgets(console->vs,sname,70)))
		Stask();
	if(i == 27 || !sname[0]) {
	        nprintf(CONSOLE,"Cancelled\n");
	       	wrest(t);
	       	return;
	}
	if(Script_Spawn(sname,t))
	       	nprintf(CONSOLE,"Spawned Script (%s)\n",sname);
	wrest(t);
}
#endif
/*************************************************************************/
/*  addsess
*   Add a session to a named machine, or prompt for a machine to be named.
*/
struct twin
*addsess(st,port)
	char *st;
	int port;
	{
	int i,new,cv;
        int destport;
	struct twin *newin = NULL;
        char    *cp,*x = NULL;
        char    buff[40];

	cv = console->vs;

        destport = 0;

	if (st == NULL) {			/* no machine yet */
		wrest(console);
		nprintf(CONSOLE,"\nEnter new machine name, address or @scriptfile ");
	 	if(port == 514)
		        nprintf(CONSOLE,"(machine [-l userid] command)\n\nRshell> ");
		else if(port == 513)
		       	nprintf(CONSOLE,"(machine [-l userid])\n\nRlogin> ");
		else
			nprintf(CONSOLE,"(machine [optional portnumber])\n\nTelnet> ");
		s[0] = '\0';
		while (0 >= (i = RSgets(cv,s,70)))
			Stask();
		if (i == 27 || !s[0]) 
			return(NULL);
		nprintf(CONSOLE,"\n");	/* skip down a little */
		st = s;					/* make a copy of the pointer to s */
        }
 	 else {
		strcpy(s,st);
		st = s;
	 }
        /* add code to support connecting to a different destination port number
           entry is like this     hostname<space>portnumber
           portnumber is  
                decimal   25
                octal     031
             or Hex       0x19

            bkc   1/28/89
         */
	{
#ifdef	SCRIPT
		if(*s == '@') {	/* A script file */
		       	st++;
		       	nprintf(CONSOLE,"\nSpawning Script (%s)\n",st);
			Script_Spawn(st,NULL); /* probably recursive */
			return(NULL);
		 }
#endif
                if(cp = strchr(s,' ')) {
		 	 if(port == 513 || port == 514) {
				x = cp;
				while(*x && isascii(*x) && isspace(*x))
				       	x++;
				if(*x && !strncmp(x,"-l",2)) {	/* userid */
				       	char	*y;
				       	y = strchr(x,' ');
					if(y) {
						while(*y && isascii(*y) && isspace(*y))
						       	y++;
						if(*y) {
						       	extern char *destuserptr, destuser[32];
							strncpy(destuser,y,31);
							destuserptr = destuser;
							destuser[31] = 0;	/* cya */
							if(x  = strchr(destuser,' '))
							       	*x = 0;
							x = strchr(y,' ');
						 	if(x)
							 	while(*x && isascii(*x) && isspace(*x))
								       	x++;
						 }
					 }
				 }
			  	 if(x && *x) {
					if(port != 514)
					       	nprintf(CONSOLE,"\nCommands not allowed with Rlogin (ignored)\n");
				 }
			 }
                        while(!isdigit(*cp) && *cp)     /* skip blanks */
                                cp++;

                        if(*cp) {
                                if(*(cp+1) == 'x' || *(cp+1) == 'X')
                                        sscanf(cp+2,"%x",&destport);
                                else
                                   if(*cp == '0')
                                        sscanf(cp+1,"%o",&destport);
                                else
                                        sscanf(cp,"%u",&destport);
                        }
		  	if(port == 513 || port == 514)
			       	destport = 0;	/* can't rlogin to any other port */
			else if(!destport)
                                nprintf(CONSOLE,"\nInvalid Destination Port Entered\n");
                        cp = strchr(s,' ');
                        *cp = 0;    /* chop it off now */
                }
	}
	if(port == 513 || port == 514)
	       destport = port;

	mp = Sgethost(st);			/* gain access to host information */
	errhandle();

	if (!mp) {
#ifdef	SCRIPT
		if(mp = Shostlook(st)) {
			if(*mp->hname == '@') {
			       	nprintf(CONSOLE,"\nSpawning Script (%s)\n",mp->hname+1);
				Script_Spawn(mp->hname+1,NULL); /* probably recursive */
				return(NULL);	
			}
		}
		else
			mp = NULL;
#endif
		if ( (i = Sdomain(st)) > 0) {
#ifdef CONSOLE_VERBOSE
			nprintf(CONSOLE,"\nQuerying the DOMAIN name server\n");
#endif
                        if(mp = Slooknum(i)) {
                                mp->destport = destport;
				 if(port == 513 || port == 514) {
					mp->flags |= TWIN_FLAGS_NOSHOW_PORT;
					if(x && *x && port == 514)
					       	mp->command = mem_strdup(x);
					else
					        mp->command = NULL;
				 }
	
			 }
                }
		else {
			nprintf(CONSOLE,"\nNo nameserver, cannot resolve IP address\n");
			return(NULL);
		}
	}
	else {
/*
*   tell user about it on the console
*/             if(destport)
                        mp->destport = destport;
		if(port == 513 || port == 514) {
		       	mp->flags |= TWIN_FLAGS_NOSHOW_PORT;
			if(x && *x && port == 514) 
			        mp->command = mem_strdup(x);
		 }
#ifdef CONSOLE_VERBOSE
		nprintf(CONSOLE,"\nTrying to open TCP connection ");
#endif
               if(mp->destport) {
#ifdef CONSOLE_VERBOSE
                        nprintf(CONSOLE,"to Port %u",mp->destport);
#endif
			 if(mp->destport == 513 || mp->destport == 514) 
				RloginGetPort();	/* set up a privilaged port */

                }
#ifdef CONSOLE_VERBOSE
		nprintf(CONSOLE,"\n");
#endif

	/* try to serve the request */

		if ( 0 > (new = Snetopen(mp,port = (mp->destport ? mp->destport : HTELNET)))) {
			errhandle();
			nprintf(CONSOLE,"\nCould not open new connection");
                        if(mp->destport) {
                                nprintf(CONSOLE,"to Port %u",mp->destport);
                        }

			nprintf(CONSOLE,"\n");
			if(!(mp->flags & TWIN_FLAGS_CONFIG_PORT))	/* this flag is set if we read the destport from the config.tel file */
	                        mp->destport = 0;       /* clear for next connection */
			return(NULL);
		}
		newin = creatwindow();
		if (!newin) {				/* mem error */
			nprintf(CONSOLE,"\nMemory Allocation error for window\n");
			return(NULL);
		}

	 	if(mp->destport == 513)
		       	newin->telstate = RLOGIN;
		else
		       if(mp->destport == 514) {
			      	newin->telstate = RSHELL;
				newin->linemode[0]= 0;
				if(mp->command) {
				       	strncpy(newin->linemode,mp->command,81);
					newin->linemode[81] = 0;
					mem_free(mp->command);
				}
			}
                if(mp->destport && !(mp->flags & TWIN_FLAGS_NOSHOW_PORT)) {
                        sprintf(buff,"%u",mp->destport);
                        i = strlen(buff);
                        sprintf(buff,"%-*.*s %u",13-i,13-i,st,mp->destport);
                        st = buff;
			if(!(mp->flags & TWIN_FLAGS_CONFIG_PORT))
	                        mp->destport = 0;               /* clear for next connection */
                }
	  	 else
				mp->destport = 0;


		newin->pnum = new;
		strncpy(newin->mname,st,14);
		newin->mname[14] = 0;

		inswindow(newin,1);
		vhead(newin->vs);
		if(mp->vtwrap == 2) {
		   	LoadInit(newin);
			newin->termstate = LOADTYPE;
		}
#ifdef	SCRIPT
	 	if(*mp->hname == '@') {
			Script_Spawn(mp->hname+1,newin);
	       }
#endif
	}

	return(newin);

}

/***********************************************************************/
/*  capstat
*
*/
capstat(s)
	char *s;
	{
	int r,c;

	r = n_row();
	c = n_col();

	n_cur(NUMLINES+1,54);     /* mabey not */
	n_draw(s,strlen(s));

	n_cur(r,c);
}

/***********************************************************************/
/*  scrollback
*   Take keyboard keys to manipulate the screen's scrollback
*   
*/
scrollback()
	{
	unsigned int c;

	while (( c = n_chkchar()) != 0xffff) {
		switch (c & ~0x1000) {
			case CURUP:
				VSscrolback(current->vs,1);
				break;
			case CURDN:
				VSscrolforward(current->vs,1);
				break;
			case PGUP:
				VSscrolback(current->vs,22);
				break;
			case PGDN:
				VSscrolforward(current->vs,22);
				break;
			case ALTD:
			       	DoScreenDump();
			default:
				break;
		}
	}

}


DoScreenDump()
{
                                if(!capon) {
                                        extern FILE *Sopencap();
					if (NULL == (current->capfp = Sopencap())) {
						nprintf(CONSOLE,"\nCannot open capture file for screendump\n");
                                                wrest(console);
                                                viewmode = 2;
						return;
					}
                                        screendump(current);
                                        fclose(current->capfp);
                                        current->capfp = NULL;
                                        return;
                                }
                                if(current->capon && current->capfp)
                                        screendump(current);
                                else {
					nprintf(CONSOLE,"\nAnother session has capture file open, cannot screendump\n");
					wrest(console);
					viewmode=2;
                                }
}

/* End of lookovr.c */
